/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskGroup
extends BackgroundTaskQueue {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskGroup.class);
    @NotNull
    protected final List<VcsException> myExceptions;
    @NotNull
    private final Project myProject;

    public BackgroundTaskGroup(@NotNull Project project2, @NotNull String title) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "<init>"));
        }
        super(project2, title);
        this.myExceptions = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
    }

    @Override
    public void run(@NotNull Task.Backgroundable task2, @Nullable ModalityState modalityState, @Nullable ProgressIndicator indicator) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "run"));
        }
        throw new UnsupportedOperationException();
    }

    public void runInBackground(@NotNull String title, @NotNull ThrowableConsumer<ProgressIndicator, VcsException> task2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "runInBackground"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "runInBackground"));
        }
        this.myProcessor.add(continuation -> {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "lambda$runInBackground$0"));
            }
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "lambda$runInBackground$0"));
            }
            new Task.Backgroundable(this.myProject, title, true, (ThrowableConsumer)task2, (Runnable)continuation){
                final /* synthetic */ ThrowableConsumer val$task;
                final /* synthetic */ Runnable val$continuation;
                {
                    this.val$task = throwableConsumer;
                    this.val$continuation = runnable2;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    block3: {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup$1", "run"));
                        }
                        indicator.setIndeterminate(true);
                        try {
                            this.val$task.consume((Object)indicator);
                        }
                        catch (VcsException e2) {
                            BackgroundTaskGroup.this.addError(e2);
                            if (e2.isWarning()) break block3;
                            indicator.cancel();
                        }
                    }
                }

                public void onCancel() {
                    BackgroundTaskGroup.this.end();
                }

                public void onThrowable(@NotNull Throwable e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup$1", "onThrowable"));
                    }
                    LOG.error(e2);
                    BackgroundTaskGroup.this.end();
                }

                public void onFinished() {
                    this.val$continuation.run();
                }
            }.queue();
        });
    }

    public void runInEdt(@NotNull ThrowableRunnable<VcsException> task2) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "runInEdt"));
        }
        this.myProcessor.add(continuation -> {
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "lambda$runInEdt$1"));
            }
            boolean isSuccess = false;
            try {
                task2.run();
                isSuccess = true;
            }
            catch (VcsException e2) {
                this.addError(e2);
                isSuccess = e2.isWarning();
            }
            finally {
                if (!isSuccess) {
                    this.end();
                }
                continuation.run();
            }
        });
    }

    public void addError(@NotNull VcsException e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/BackgroundTaskGroup", "addError"));
        }
        this.myExceptions.add(e2);
    }

    public void showErrors() {
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myExceptions, this.myTitle);
        }
    }

    public void end() {
        this.myProcessor.clear();
        this.showErrors();
    }
}

