/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SelectedBlockHistoryAction
extends AbstractVcsAction {
    protected boolean isEnabled(VcsContext context2) {
        Project project2 = context2.getProject();
        if (project2 == null) {
            return false;
        }
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context2);
        if (selection == null) {
            return false;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(selection.getDocument());
        if (file2 == null) {
            return false;
        }
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project2);
        BackgroundableActionEnabledHandler handler2 = vcsManager.getBackgroundableActionHandler(VcsBackgroundableActions.HISTORY_FOR_SELECTION);
        if (handler2.isInProgress(VcsBackgroundableActions.keyFrom(file2))) {
            return false;
        }
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
        if (activeVcs == null) {
            return false;
        }
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        if (provider == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project2, (FilePath)VcsUtil.getFilePath((VirtualFile)file2));
    }

    @Override
    public void actionPerformed(@NotNull VcsContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction", "actionPerformed"));
        }
        try {
            final Project project2 = context2.getProject();
            assert (project2 != null);
            final VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context2);
            assert (selection != null);
            final VirtualFile file2 = FileDocumentManager.getInstance().getFile(selection.getDocument());
            assert (file2 != null);
            final AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
            assert (activeVcs != null);
            final VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
            assert (provider != null);
            final int selectionStart = selection.getSelectionStartLineNumber();
            final int selectionEnd = selection.getSelectionEndLineNumber();
            new VcsHistoryProviderBackgroundableProxy(activeVcs, provider, activeVcs.getDiffProvider()).createSessionFor(activeVcs.getKeyInstanceMethod(), VcsUtil.getFilePath((VirtualFile)file2), new Consumer<VcsHistorySession>(){

                public void consume(VcsHistorySession session2) {
                    if (session2 == null) {
                        return;
                    }
                    VcsSelectionHistoryDialog vcsHistoryDialog = new VcsSelectionHistoryDialog(project2, file2, selection.getDocument(), provider, session2, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle());
                    vcsHistoryDialog.show();
                }
            }, VcsBackgroundableActions.HISTORY_FOR_SELECTION, false, null);
        }
        catch (Exception exception) {
            SelectedBlockHistoryAction.reportError(exception);
        }
    }

    @Override
    protected void update(@NotNull VcsContext context2, @NotNull Presentation presentation) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction", "update"));
        }
        presentation.setEnabled(this.isEnabled(context2));
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context2);
        if (selection != null) {
            presentation.setText(selection.getActionName());
        }
    }

    protected static void reportError(Exception exception) {
        Messages.showMessageDialog((String)exception.getLocalizedMessage(), (String)VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }
}

