/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import org.jetbrains.annotations.NotNull;

public abstract class ShowChangeMarkerAction
extends AbstractVcsAction {
    protected final ChangeMarkerContext myChangeMarkerContext;

    protected abstract Range extractRange(LineStatusTracker var1, int var2, Editor var3);

    public ShowChangeMarkerAction(final Range range, final LineStatusTracker lineStatusTracker, final Editor editor) {
        this.myChangeMarkerContext = new ChangeMarkerContext(){

            @Override
            public Range getRange(VcsContext dataContext) {
                return range;
            }

            @Override
            public LineStatusTracker getLineStatusTracker(VcsContext dataContext) {
                return lineStatusTracker;
            }

            @Override
            public Editor getEditor(VcsContext dataContext) {
                return editor;
            }
        };
    }

    public ShowChangeMarkerAction() {
        this.myChangeMarkerContext = new ChangeMarkerContext(){

            @Override
            public Range getRange(VcsContext context2) {
                Editor editor = this.getEditor(context2);
                if (editor == null) {
                    return null;
                }
                LineStatusTracker lineStatusTracker = this.getLineStatusTracker(context2);
                if (lineStatusTracker == null) {
                    return null;
                }
                return ShowChangeMarkerAction.this.extractRange(lineStatusTracker, editor.getCaretModel().getLogicalPosition().line, editor);
            }

            @Override
            public LineStatusTracker getLineStatusTracker(VcsContext dataContext) {
                Editor editor = this.getEditor(dataContext);
                if (editor == null) {
                    return null;
                }
                Project project2 = dataContext.getProject();
                if (project2 == null) {
                    return null;
                }
                return LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(editor.getDocument());
            }

            @Override
            public Editor getEditor(VcsContext dataContext) {
                return dataContext.getEditor();
            }
        };
    }

    private boolean isActive(VcsContext context2) {
        Editor editor = this.myChangeMarkerContext.getEditor(context2);
        return this.myChangeMarkerContext.getRange(context2) != null && editor != null && !DiffUtil.isDiffEditor(editor);
    }

    @Override
    protected void update(@NotNull VcsContext context2, @NotNull Presentation presentation) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction", "update"));
        }
        LineStatusTracker tracker = this.myChangeMarkerContext.getLineStatusTracker(context2);
        if (tracker == null || !tracker.isValid() || tracker.isSilentMode()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean active2 = this.isActive(context2);
        presentation.setEnabled(active2);
        presentation.setVisible(this.myChangeMarkerContext.getEditor(context2) != null || ActionPlaces.isToolbarPlace((String)((String)context2.getPlace())));
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction", "actionPerformed"));
        }
        Editor editor = this.myChangeMarkerContext.getEditor(context2);
        LineStatusTracker lineStatusTracker = this.myChangeMarkerContext.getLineStatusTracker(context2);
        Range range = this.myChangeMarkerContext.getRange(context2);
        LineStatusTrackerDrawing.moveToRange(range, editor, lineStatusTracker);
    }

    protected static interface ChangeMarkerContext {
        public Range getRange(VcsContext var1);

        public LineStatusTracker getLineStatusTracker(VcsContext var1);

        public Editor getEditor(VcsContext var1);
    }
}

