/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CacheOneStepIterator;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowDiffFromAnnotation
extends DumbAwareAction
implements UpToDateLineNumberListener {
    private final FileAnnotation myFileAnnotation;
    private final AbstractVcs myVcs;
    private final VirtualFile myFile;
    private int currentLine;
    private boolean myEnabled;
    private static final int ourVicinity = 5;

    ShowDiffFromAnnotation(FileAnnotation fileAnnotation, AbstractVcs vcs, VirtualFile file2) {
        super(ActionsBundle.message((String)"action.Diff.UpdatedFiles.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.Diff.UpdatedFiles.description", (Object[])new Object[0]), AllIcons.Actions.Diff);
        this.myFileAnnotation = fileAnnotation;
        this.myVcs = vcs;
        this.myFile = file2;
        this.currentLine = -1;
        this.myEnabled = ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).getVcsFor(this.myFile) != null;
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    public void update(AnActionEvent e2) {
        int number = this.currentLine;
        e2.getPresentation().setVisible(this.myEnabled);
        e2.getPresentation().setEnabled(this.myEnabled && number >= 0 && number < this.myFileAnnotation.getLineCount());
    }

    public void actionPerformed(AnActionEvent e2) {
        final int actualNumber = this.currentLine;
        if (actualNumber < 0) {
            return;
        }
        final VcsRevisionNumber revisionNumber = this.myFileAnnotation.getLineRevisionNumber(actualNumber);
        if (revisionNumber != null) {
            final VcsException[] exc = new VcsException[1];
            final LinkedList changes = new LinkedList();
            final FilePath[] targetPath = new FilePath[1];
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myVcs.getProject(), "Loading revision " + revisionNumber.asString() + " contents", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$1", "run"));
                    }
                    CommittedChangesProvider provider = ShowDiffFromAnnotation.this.myVcs.getCommittedChangesProvider();
                    try {
                        Pair pair = provider.getOneList(ShowDiffFromAnnotation.this.myFile, revisionNumber);
                        if (pair == null || pair.getFirst() == null) {
                            VcsBalloonProblemNotifier.showOverChangesView(ShowDiffFromAnnotation.this.myVcs.getProject(), "Can not load data for show diff", MessageType.ERROR, new NamedRunnable[0]);
                            return;
                        }
                        targetPath[0] = pair.getSecond() == null ? VcsUtil.getFilePath((VirtualFile)ShowDiffFromAnnotation.this.myFile) : (FilePath)pair.getSecond();
                        CommittedChangeList cl = (CommittedChangeList)pair.getFirst();
                        changes.addAll(cl.getChanges());
                        Collections.sort(changes, ChangesComparator.getInstance(true));
                    }
                    catch (VcsException e1) {
                        exc[0] = e1;
                    }
                }

                public void onSuccess() {
                    if (exc[0] != null) {
                        VcsBalloonProblemNotifier.showOverChangesView(ShowDiffFromAnnotation.this.myVcs.getProject(), "Can not show diff: " + exc[0].getMessage(), MessageType.ERROR, new NamedRunnable[0]);
                    } else if (!changes.isEmpty()) {
                        int idx = ShowDiffFromAnnotation.findSelfInList(changes, targetPath[0]);
                        ShowDiffContext context2 = new ShowDiffContext(DiffDialogHints.FRAME);
                        if (idx != -1) {
                            context2.putChangeContext((Change)changes.get(idx), DiffUserDataKeysEx.NAVIGATION_CONTEXT, ShowDiffFromAnnotation.this.createDiffNavigationContext(actualNumber));
                        }
                        if (ChangeListManager.getInstance((Project)ShowDiffFromAnnotation.this.myVcs.getProject()).isFreezedWithNotification(null)) {
                            return;
                        }
                        ShowDiffAction.showDiffForChange(ShowDiffFromAnnotation.this.myVcs.getProject(), (Iterable<Change>)changes, idx, context2);
                    }
                }
            });
        }
    }

    private static int findSelfInList(@NotNull List<Change> changes, @NotNull FilePath filePath) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation", "findSelfInList"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation", "findSelfInList"));
        }
        int idx = -1;
        for (int i2 = 0; i2 < changes.size(); ++i2) {
            Change change = changes.get(i2);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().equals(filePath)) continue;
            idx = i2;
            break;
        }
        if (idx >= 0) {
            return idx;
        }
        idx = 0;
        String name = filePath.getName();
        for (int i3 = 0; i3 < changes.size(); ++i3) {
            Change change = changes.get(i3);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().getName().equals(name)) continue;
            idx = i3;
            break;
        }
        return idx;
    }

    @Nullable
    private DiffNavigationContext createDiffNavigationContext(int actualLine) {
        String annotatedContent = this.myFileAnnotation.getAnnotatedContent();
        if (StringUtil.isEmptyOrSpaces((String)annotatedContent)) {
            return null;
        }
        final String[] contentsLines = LineTokenizer.tokenize((CharSequence)annotatedContent, (boolean)false, (boolean)false);
        if (contentsLines.length <= actualLine) {
            return null;
        }
        final int correctedLine = this.correctActualLineIfTextEmpty(contentsLines, actualLine);
        return new DiffNavigationContext((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new CacheOneStepIterator((Iterator)new ContextLineIterator(contentsLines, ShowDiffFromAnnotation.this.myFileAnnotation, correctedLine));
            }
        }, contentsLines[correctedLine]);
    }

    private int correctActualLineIfTextEmpty(@NotNull String[] contentsLines, int actualLine) {
        if (contentsLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentsLines", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation", "correctActualLineIfTextEmpty"));
        }
        VcsRevisionNumber revision = this.myFileAnnotation.getLineRevisionNumber(actualLine);
        if (revision == null) {
            return actualLine;
        }
        if (!StringUtil.isEmptyOrSpaces((String)contentsLines[actualLine])) {
            return actualLine;
        }
        int upperBound = Math.min(actualLine + 5, contentsLines.length);
        for (int i2 = actualLine + 1; i2 < upperBound; ++i2) {
            if (!revision.equals(this.myFileAnnotation.getLineRevisionNumber(i2)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i2])) continue;
            return i2;
        }
        int lowerBound = Math.max(actualLine - 5, 0);
        for (int i3 = actualLine - 1; i3 >= lowerBound; --i3) {
            if (!revision.equals(this.myFileAnnotation.getLineRevisionNumber(i3)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i3])) continue;
            return i3;
        }
        return actualLine;
    }

    private static class ContextLineIterator
    implements Iterator<String> {
        @NotNull
        private final String[] myContentsLines;
        private final VcsRevisionNumber myRevisionNumber;
        @NotNull
        private final FileAnnotation myAnnotation;
        private final int myStopAtLine;
        private int myCurrentLine;

        private ContextLineIterator(@NotNull String[] contentLines, @NotNull FileAnnotation annotation, int stopAtLine) {
            if (contentLines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentLines", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$ContextLineIterator", "<init>"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$ContextLineIterator", "<init>"));
            }
            this.myAnnotation = annotation;
            this.myRevisionNumber = this.myAnnotation.originalRevision(stopAtLine);
            this.myStopAtLine = stopAtLine;
            this.myContentsLines = contentLines;
        }

        @Override
        public boolean hasNext() {
            return this.myRevisionNumber != null && this.lineNumberInBounds();
        }

        private boolean lineNumberInBounds() {
            return this.myCurrentLine < this.myContentsLines.length && this.myCurrentLine < this.myStopAtLine;
        }

        @Override
        public String next() {
            while (this.lineNumberInBounds()) {
                VcsRevisionNumber vcsRevisionNumber = this.myAnnotation.originalRevision(this.myCurrentLine);
                String text2 = this.myContentsLines[this.myCurrentLine];
                ++this.myCurrentLine;
                if (!this.myRevisionNumber.equals(vcsRevisionNumber) || StringUtil.isEmptyOrSpaces((String)text2)) continue;
                return text2;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

