/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.ui.Refreshable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShowMessageHistoryAction
extends AnAction
implements DumbAware {
    public ShowMessageHistoryAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        DataContext dc2 = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc2);
        Object panel2 = CheckinProjectPanel.PANEL_KEY.getData(dc2);
        if (!(panel2 instanceof CommitMessageI)) {
            panel2 = VcsDataKeys.COMMIT_MESSAGE_CONTROL.getData(dc2);
        }
        if (project2 == null || panel2 == null) {
            e2.getPresentation().setVisible(false);
            e2.getPresentation().setEnabled(false);
        } else {
            e2.getPresentation().setVisible(true);
            ArrayList recentMessages = VcsConfiguration.getInstance((Project)project2).getRecentMessages();
            e2.getPresentation().setEnabled(!recentMessages.isEmpty());
        }
    }

    public void actionPerformed(AnActionEvent e2) {
        int selectedIndex;
        ContentChooser<String> contentChooser;
        VcsConfiguration configuration;
        CommitMessageI commitMessageI;
        DataContext dc2 = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc2);
        Refreshable panel2 = (Refreshable)CheckinProjectPanel.PANEL_KEY.getData(dc2);
        CommitMessageI commitMessageI2 = commitMessageI = panel2 instanceof CommitMessageI ? (CommitMessageI)panel2 : (CommitMessageI)VcsDataKeys.COMMIT_MESSAGE_CONTROL.getData(dc2);
        if (commitMessageI != null && project2 != null && !(configuration = VcsConfiguration.getInstance((Project)project2)).getRecentMessages().isEmpty() && (contentChooser = new ContentChooser<String>(project2, VcsBundle.message((String)"dialog.title.choose.commit.message.from.history", (Object[])new Object[0]), false){

            @Override
            protected void removeContentAt(String content2) {
                configuration.removeMessage(content2);
            }

            @Override
            protected String getStringRepresentationFor(String content2) {
                return content2;
            }

            @Override
            protected List<String> getContents() {
                ArrayList recentMessages = configuration.getRecentMessages();
                Collections.reverse(recentMessages);
                return recentMessages;
            }
        }).showAndGet() && (selectedIndex = contentChooser.getSelectedIndex()) >= 0) {
            commitMessageI.setCommitMessage((String)contentChooser.getAllContents().get(selectedIndex));
        }
    }
}

