/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

class SwitchAnnotationSourceAction
extends AnAction {
    private static final String ourShowMerged = VcsBundle.message((String)"annotation.switch.to.merged.text", (Object[])new Object[0]);
    private static final String ourHideMerged = VcsBundle.message((String)"annotation.switch.to.original.text", (Object[])new Object[0]);
    private final AnnotationSourceSwitcher mySwitcher;
    private final EditorGutterComponentEx myGutter;
    private final List<Consumer<AnnotationSource>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myShowMerged;

    SwitchAnnotationSourceAction(AnnotationSourceSwitcher switcher, EditorGutterComponentEx gutter) {
        this.mySwitcher = switcher;
        this.myGutter = gutter;
        this.myShowMerged = this.mySwitcher.getDefaultSource().showMerged();
    }

    public void addSourceSwitchListener(Consumer<AnnotationSource> listener2) {
        this.myListeners.add(listener2);
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setText(this.myShowMerged ? ourHideMerged : ourShowMerged);
    }

    public void actionPerformed(AnActionEvent e2) {
        this.myShowMerged = !this.myShowMerged;
        AnnotationSource newSource = AnnotationSource.getInstance((boolean)this.myShowMerged);
        this.mySwitcher.switchTo(newSource);
        for (Consumer<AnnotationSource> listener2 : this.myListeners) {
            listener2.consume((Object)newSource);
        }
        this.myGutter.revalidateMarkup();
    }
}

