/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    @NotNull
    protected final DataContext myContext;
    protected final int myModifiers;
    @NotNull
    private final String myPlace;
    @Nullable
    private final String myActionName;

    public VcsContextWrapper(@NotNull DataContext context2, int modifiers, @NotNull String place, @Nullable String actionName) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "<init>"));
        }
        this.myContext = context2;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    @NotNull
    public String getPlace() {
        String string2 = this.myPlace;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getPlace"));
        }
        return string2;
    }

    @Nullable
    public String getActionName() {
        return this.myActionName;
    }

    @NotNull
    public static VcsContext createCachedInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createCachedInstanceOn"));
        }
        CachedVcsContext cachedVcsContext = new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
        if (cachedVcsContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createCachedInstanceOn"));
        }
        return cachedVcsContext;
    }

    @NotNull
    public static VcsContextWrapper createInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createInstanceOn"));
        }
        VcsContextWrapper vcsContextWrapper = new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
        if (vcsContextWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createInstanceOn"));
        }
        return vcsContextWrapper;
    }

    @Nullable
    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        return this.getSelectedFilesStream().findFirst().orElse(null);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        VirtualFile[] fileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(this.myContext);
        if (fileArray != null) {
            VirtualFile[] virtualFileArray2 = (VirtualFile[])Stream.of(fileArray).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
            if (virtualFileArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
            }
            return virtualFileArray2;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myContext);
        if (file2 != null && file2.isInLocalFileSystem()) {
            VirtualFile[] virtualFileArray3 = new VirtualFile[1];
            virtualFileArray = virtualFileArray3;
            virtualFileArray3[0] = file2;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedFilesStream() {
        Stream result2 = (Stream)VcsDataKeys.VIRTUAL_FILE_STREAM.getData(this.myContext);
        Stream<VirtualFile> stream = result2 != null ? result2.filter(VirtualFile::isInLocalFileSystem) : super.getSelectedFilesStream();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFilesStream"));
        }
        return stream;
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    @Nullable
    public File getSelectedIOFile() {
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        return file2 != null ? file2 : (File)ArrayUtil.getFirstElement((Object[])((Object[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext)));
    }

    @Nullable
    public File[] getSelectedIOFiles() {
        File[] fileArray;
        Object[] files2 = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (!ArrayUtil.isEmpty((Object[])files2)) {
            return files2;
        }
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        if (file2 != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file2;
        } else {
            fileArray = null;
        }
        return fileArray;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Refreshable getRefreshableDialog() {
        return (Refreshable)Refreshable.PANEL_KEY.getData(this.myContext);
    }

    @NotNull
    public FilePath[] getSelectedFilePaths() {
        FilePath[] filePathArray = (FilePath[])this.getSelectedFilePathsStream().toArray(FilePath[]::new);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFilePaths"));
        }
        return filePathArray;
    }

    @NotNull
    public Stream<FilePath> getSelectedFilePathsStream() {
        FilePath path = (FilePath)VcsDataKeys.FILE_PATH.getData(this.myContext);
        Stream<FilePath> stream = UtilKt.concat(path != null ? Stream.of(path) : Stream.empty(), UtilKt.stream((Object[])VcsDataKeys.FILE_PATH_ARRAY.getData(this.myContext)), this.getSelectedFilesStream().map(VcsUtil::getFilePath), UtilKt.stream(this.getSelectedIOFiles()).map(VcsUtil::getFilePath));
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFilePathsStream"));
        }
        return stream;
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        return (FilePath)ArrayUtil.getFirstElement((Object[])this.getSelectedFilePaths());
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }
}

