/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsPreviewPanel
implements PreviewPanel {
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final EditorEx myEditor;

    public VcsPreviewPanel() {
        DocumentImpl document = new DocumentImpl("", true);
        this.myEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)document);
        this.myEditor.getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        this.myEditor.getSettings().setFoldingOutlineShown(true);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void blinkSelectedHighlightType(Object selected) {
    }

    @Override
    public void updateView() {
        EditorColorsScheme colorsScheme = this.myEditor.getColorsScheme();
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Deleted line below\n\nModified line\n\nAdded line\n\nLine with modified whitespaces\n\nAdded line\nLine with modified whitespaces and deletion after\n");
        int additionalLines = Math.max(0, AnnotationsSettings.getInstance().getOrderedColors(colorsScheme).size() - StringUtil.countNewLines((CharSequence)sb2));
        sb2.append(StringUtil.repeat((String)"\n", (int)additionalLines));
        this.myEditor.getDocument().setText(sb2);
        this.myEditor.getMarkupModel().removeAllHighlighters();
        this.myEditor.getGutterComponentEx().closeAllAnnotations();
        this.addHighlighter(new Range(1, 1, 0, 1), EditorColors.DELETED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(2, 1), EditorColors.MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(4, 2), EditorColors.ADDED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(6, 0), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(8, 2, 0, 3), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        List<Color> annotationColors = AnnotationsSettings.getInstance().getOrderedColors(colorsScheme);
        List<Integer> anchorIndexes = AnnotationsSettings.getInstance().getAnchorIndexes(colorsScheme);
        this.myEditor.getGutterComponentEx().registerTextAnnotation(new MyTextAnnotationGutterProvider(annotationColors, anchorIndexes));
    }

    @NotNull
    private static Range createModifiedRange(int currentLine, byte ... inner) {
        ArrayList<Range.InnerRange> innerRanges = new ArrayList<Range.InnerRange>();
        int currentInnerLine = currentLine;
        block4: for (byte type : inner) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine + 1, type));
                    ++currentInnerLine;
                    continue block4;
                }
                case 3: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine, type));
                }
            }
        }
        Range range = new Range(currentLine, currentInnerLine, 0, 1, innerRanges);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsPreviewPanel", "createModifiedRange"));
        }
        return range;
    }

    private void addHighlighter(@NotNull Range range, final @NotNull ColorKey colorKey) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/actions/VcsPreviewPanel", "addHighlighter"));
        }
        if (colorKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorKey", "com/intellij/openapi/vcs/actions/VcsPreviewPanel", "addHighlighter"));
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myEditor.getDocument(), range.getLine1(), range.getLine2());
        RangeHighlighter highlighter2 = LineStatusMarkerRenderer.createRangeHighlighter(range, textRange, this.myEditor.getMarkupModel());
        highlighter2.setLineMarkerRenderer((LineMarkerRenderer)new LineStatusMarkerRenderer(range){

            @Override
            public boolean canDoAction(MouseEvent e2) {
                return 1.isInsideMarkerArea(e2);
            }

            @Override
            public void doAction(Editor editor, MouseEvent e2) {
                ((ColorAndFontSettingsListener)VcsPreviewPanel.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(colorKey.getExternalName());
            }
        });
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/actions/VcsPreviewPanel", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        this.myEditor.setColorsScheme(highlighterSettings);
    }

    private static class MyTextAnnotationGutterProvider
    implements TextAnnotationGutterProvider {
        @NotNull
        private final List<Color> myBackgroundColors;
        @NotNull
        private final List<Integer> myAnchorIndexes;

        public MyTextAnnotationGutterProvider(@NotNull List<Color> backgroundColors, @NotNull List<Integer> anchorIndexes) {
            if (backgroundColors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundColors", "com/intellij/openapi/vcs/actions/VcsPreviewPanel$MyTextAnnotationGutterProvider", "<init>"));
            }
            if (anchorIndexes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorIndexes", "com/intellij/openapi/vcs/actions/VcsPreviewPanel$MyTextAnnotationGutterProvider", "<init>"));
            }
            this.myBackgroundColors = backgroundColors;
            this.myAnchorIndexes = anchorIndexes;
        }

        @Nullable
        public String getLineText(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                int anchorIndex = this.myAnchorIndexes.indexOf(line);
                String text2 = "Annotation background";
                if (anchorIndex != -1) {
                    text2 = text2 + " #" + (anchorIndex + 1);
                }
                return text2;
            }
            return null;
        }

        @Nullable
        public String getToolTip(int line, Editor editor) {
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            return null;
        }

        @Nullable
        public ColorKey getColor(int line, Editor editor) {
            return EditorColors.ANNOTATIONS_COLOR;
        }

        @Nullable
        public Color getBgColor(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                return this.myBackgroundColors.get(line);
            }
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
        }
    }
}

