/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsQuickListPopupAction
extends QuickSwitchSchemeAction
implements DumbAware {
    public VcsQuickListPopupAction() {
        this.myActionPlace = "ActionPlace.VcsQuickListPopupAction";
    }

    protected void fillActions(@Nullable Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillActions"));
        }
        if (project2 == null) {
            return;
        }
        Pair<SupportedVCS, AbstractVcs> typeAndVcs = this.getActiveVCS(project2, dataContext);
        AbstractVcs vcs = (AbstractVcs)typeAndVcs.getSecond();
        SupportedVCS popupType = (SupportedVCS)((Object)typeAndVcs.getFirst());
        switch (popupType) {
            case VCS: {
                this.fillVcsPopup(project2, group, dataContext, vcs);
                break;
            }
            case NOT_IN_VCS: {
                this.fillNonInVcsActions(project2, group, dataContext);
            }
        }
    }

    private void fillVcsPopup(@NotNull Project project2, @NotNull DefaultActionGroup group, @Nullable DataContext dataContext, @Nullable AbstractVcs vcs) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillVcsPopup"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillVcsPopup"));
        }
        if (vcs != null) {
            for (VcsQuickListContentProvider provider : (VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()) {
                List actionsToReplace;
                if (!provider.replaceVcsActionsFor(vcs, dataContext) || (actionsToReplace = provider.getVcsActions(project2, vcs, dataContext)) == null) continue;
                this.addActions(actionsToReplace, group);
                this.addLocalHistoryActions(group);
                return;
            }
        }
        this.fillGeneralVcsPopup(project2, group, dataContext, vcs);
    }

    private void fillGeneralVcsPopup(@NotNull Project project2, @NotNull DefaultActionGroup group, @Nullable DataContext dataContext, @Nullable AbstractVcs vcs) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillGeneralVcsPopup"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillGeneralVcsPopup"));
        }
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        for (VcsQuickListContentProvider provider : (VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()) {
            List providerActions = provider.getVcsActions(project2, vcs, dataContext);
            if (providerActions == null) continue;
            actions2.addAll(providerActions);
        }
        this.addSeparator(group, vcs != null ? vcs.getDisplayName() : null);
        this.addAction("ChangesView.AddUnversioned", group);
        this.addAction("CheckinProject", group);
        this.addAction("CheckinFiles", group);
        this.addAction("ChangesView.Revert", group);
        this.addSeparator(group);
        this.addAction("Vcs.ShowTabbedFileHistory", group);
        this.addAction("Annotate", group);
        this.addAction("Compare.SameVersion", group);
        this.addSeparator(group);
        this.addActions(actions2, group);
        this.addSeparator(group);
        this.addAction("ChangesView.Move", group);
        this.addLocalHistoryActions(group);
    }

    private void fillNonInVcsActions(@NotNull Project project2, @NotNull DefaultActionGroup group, @Nullable DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillNonInVcsActions"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "fillNonInVcsActions"));
        }
        for (VcsQuickListContentProvider provider : (VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()) {
            List actions2 = provider.getNotInVcsActions(project2, dataContext);
            if (actions2 == null) continue;
            this.addActions(actions2, group);
        }
        this.addSeparator(group);
        this.addAction("Start.Use.Vcs", group);
        this.addAction("Vcs.Checkout", group);
        this.addLocalHistoryActions(group);
    }

    private void addLocalHistoryActions(DefaultActionGroup group) {
        this.addSeparator(group, VcsBundle.message((String)"vcs.quicklist.pupup.section.local.history", (Object[])new Object[0]));
        this.addAction("LocalHistory.ShowHistory", group);
        this.addAction("LocalHistory.PutLabel", group);
    }

    private void addActions(@NotNull List<AnAction> actions2, @NotNull DefaultActionGroup toGroup) {
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "addActions"));
        }
        if (toGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toGroup", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "addActions"));
        }
        for (AnAction action2 : actions2) {
            toGroup.addAction(action2);
        }
    }

    private Pair<SupportedVCS, AbstractVcs> getActiveVCS(@NotNull Project project2, @Nullable DataContext dataContext) {
        AbstractVcs vscForFile;
        VirtualFile file2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction", "getActiveVCS"));
        }
        AbstractVcs[] activeVcss = this.getActiveVCSs(project2);
        if (activeVcss.length == 0) {
            return new Pair((Object)SupportedVCS.NOT_IN_VCS, null);
        }
        if (activeVcss.length == 1) {
            return Pair.create((Object)((Object)SupportedVCS.VCS), (Object)activeVcss[0]);
        }
        VirtualFile virtualFile = file2 = dataContext != null ? (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext) : null;
        if (file2 != null && (vscForFile = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2)) != null) {
            return Pair.create((Object)((Object)SupportedVCS.VCS), (Object)vscForFile);
        }
        return new Pair((Object)SupportedVCS.VCS, null);
    }

    private AbstractVcs[] getActiveVCSs(Project project2) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        return vcsManager.getAllActiveVcss();
    }

    private void addAction(String actionId, DefaultActionGroup toGroup) {
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        if (action2 != null) {
            toGroup.add(action2);
        }
    }

    private void addSeparator(DefaultActionGroup toGroup) {
        this.addSeparator(toGroup, null);
    }

    private void addSeparator(DefaultActionGroup toGroup, @Nullable String title) {
        Separator separator = title == null ? new Separator() : new Separator(title);
        toGroup.add((AnAction)separator);
    }

    protected String getPopupTitle(AnActionEvent e2) {
        return VcsBundle.message((String)"vcs.quicklist.popup.title", (Object[])new Object[0]);
    }

    public static enum SupportedVCS {
        VCS,
        NOT_IN_VCS;

    }
}

