/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ChangeListManagerSerialization {
    @NonNls
    static final String ATT_ID = "id";
    @NonNls
    static final String ATT_NAME = "name";
    @NonNls
    static final String ATT_COMMENT = "comment";
    @NonNls
    static final String ATT_DEFAULT = "default";
    @NonNls
    static final String ATT_READONLY = "readonly";
    @NonNls
    static final String ATT_VALUE_TRUE = "true";
    @NonNls
    static final String ATT_CHANGE_TYPE = "type";
    @NonNls
    static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    static final String ATT_PATH = "path";
    @NonNls
    static final String ATT_MASK = "mask";
    @NonNls
    static final String NODE_LIST = "list";
    @NonNls
    static final String NODE_IGNORED = "ignored";
    @NonNls
    static final String NODE_CHANGE = "change";
    @NonNls
    static final String MANUALLY_REMOVED_FROM_IGNORED = "manually-removed-from-ignored";
    @NonNls
    static final String DIRECTORY_TAG = "directory";
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private final ChangeListWorker myWorker;

    ChangeListManagerSerialization(IgnoredFilesComponent ignoredIdeaLevel, ChangeListWorker worker) {
        this.myIgnoredIdeaLevel = ignoredIdeaLevel;
        this.myWorker = worker;
    }

    public void readExternal(Element element) {
        List listNodes = element.getChildren(NODE_LIST);
        for (Object listNode : listNodes) {
            this.readChangeList((Element)listNode);
        }
        List ignoredNodes = element.getChildren(NODE_IGNORED);
        for (Element ignoredNode : ignoredNodes) {
            this.readFileToIgnore(ignoredNode);
        }
        Element manuallyRemovedFromIgnoredTag = element.getChild(MANUALLY_REMOVED_FROM_IGNORED);
        HashSet<String> manuallyRemovedFromIgnoredPaths = new HashSet<String>();
        if (manuallyRemovedFromIgnoredTag != null) {
            for (Element tag : manuallyRemovedFromIgnoredTag.getChildren(DIRECTORY_TAG)) {
                manuallyRemovedFromIgnoredPaths.add(tag.getAttributeValue(ATT_PATH));
            }
        }
        this.myIgnoredIdeaLevel.setDirectoriesManuallyRemovedFromIgnored(manuallyRemovedFromIgnoredPaths);
    }

    private void readChangeList(Element listNode) {
        String changeListName = listNode.getAttributeValue(ATT_NAME);
        LocalChangeList list2 = this.myWorker.getCopyByName(changeListName);
        if (list2 == null) {
            list2 = this.myWorker.addChangeList(listNode.getAttributeValue(ATT_ID), changeListName, listNode.getAttributeValue(ATT_COMMENT), false, null);
        }
        List changeNodes = listNode.getChildren(NODE_CHANGE);
        for (Element changeNode : changeNodes) {
            try {
                this.myWorker.addChangeToList(changeListName, ChangeListManagerSerialization.readChange(changeNode), null);
            }
            catch (OutdatedFakeRevisionException outdatedFakeRevisionException) {}
        }
        if (ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT))) {
            this.myWorker.setDefault(list2.getName());
        }
        if (ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_READONLY))) {
            list2.setReadOnly(true);
        }
    }

    private void readFileToIgnore(Element ignoredNode) {
        String mask;
        IgnoredFileBean bean;
        String path = ignoredNode.getAttributeValue(ATT_PATH);
        if (path != null) {
            Project project2 = this.myWorker.getProject();
            bean = path.endsWith("/") || path.endsWith(File.separator) ? IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project2) : IgnoredBeanFactory.ignoreFile((String)path, (Project)project2);
            this.myIgnoredIdeaLevel.add(bean);
        }
        if ((mask = ignoredNode.getAttributeValue(ATT_MASK)) != null) {
            bean = IgnoredBeanFactory.withMask((String)mask);
            this.myIgnoredIdeaLevel.add(bean);
        }
    }

    public static void writeExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredFilesComponent, @NotNull ChangeListWorker worker) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeExternal"));
        }
        if (ignoredFilesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredFilesComponent", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeExternal"));
        }
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "com/intellij/openapi/vcs/changes/ChangeListManagerSerialization", "writeExternal"));
        }
        for (LocalChangeList list2 : worker.getListsCopy()) {
            Element listNode = new Element(NODE_LIST);
            element.addContent(listNode);
            if (list2.isDefault()) {
                listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
            }
            if (list2.isReadOnly()) {
                listNode.setAttribute(ATT_READONLY, ATT_VALUE_TRUE);
            }
            listNode.setAttribute(ATT_ID, list2.getId());
            listNode.setAttribute(ATT_NAME, list2.getName());
            String comment = list2.getComment();
            if (comment != null) {
                listNode.setAttribute(ATT_COMMENT, comment);
            }
            ArrayList changes = new ArrayList(list2.getChanges());
            changes.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.toString()), (Comparable)((Object)o2.toString())));
            for (Change change : changes) {
                ChangeListManagerSerialization.writeChange(listNode, change);
            }
        }
        for (IgnoredFileBean bean : ignoredFilesComponent.getFilesToIgnore()) {
            String mask;
            Element fileNode = new Element(NODE_IGNORED);
            element.addContent(fileNode);
            String path = bean.getPath();
            if (path != null) {
                fileNode.setAttribute(ATT_PATH, path);
            }
            if ((mask = bean.getMask()) == null) continue;
            fileNode.setAttribute(ATT_MASK, mask);
        }
        Set<String> manuallyRemovedFromIgnored = ignoredFilesComponent.getDirectoriesManuallyRemovedFromIgnored();
        if (!manuallyRemovedFromIgnored.isEmpty()) {
            Element list3 = new Element(MANUALLY_REMOVED_FROM_IGNORED);
            for (String path : manuallyRemovedFromIgnored) {
                list3.addContent(new Element(DIRECTORY_TAG).setAttribute(ATT_PATH, path));
            }
            element.addContent(list3);
        }
    }

    private static void writeChange(Element listNode, Change change) {
        Element changeNode = new Element(NODE_CHANGE);
        listNode.addContent(changeNode);
        changeNode.setAttribute(ATT_CHANGE_TYPE, change.getType().name());
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        changeNode.setAttribute(ATT_CHANGE_BEFORE_PATH, bRev != null ? bRev.getFile().getPath() : "");
        changeNode.setAttribute(ATT_CHANGE_AFTER_PATH, aRev != null ? aRev.getFile().getPath() : "");
    }

    private static Change readChange(Element changeNode) throws OutdatedFakeRevisionException {
        String bRev = changeNode.getAttributeValue(ATT_CHANGE_BEFORE_PATH);
        String aRev = changeNode.getAttributeValue(ATT_CHANGE_AFTER_PATH);
        return new Change((ContentRevision)(StringUtil.isEmpty((String)bRev) ? null : new FakeRevision(bRev)), (ContentRevision)(StringUtil.isEmpty((String)aRev) ? null : new FakeRevision(aRev)));
    }

    static final class OutdatedFakeRevisionException
    extends Exception {
        OutdatedFakeRevisionException() {
        }
    }
}

