/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class DelayedNotificator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.DelayedNotificator");
    private final EventDispatcher<ChangeListListener> myDispatcher;
    private final AtomicReference<Future> myFuture;
    private final ExecutorService myService;
    private final MyProxyDispatcher myProxyDispatcher;

    public DelayedNotificator(EventDispatcher<ChangeListListener> dispatcher, AtomicReference<Future> future2, @NotNull ExecutorService service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/openapi/vcs/changes/DelayedNotificator", "<init>"));
        }
        this.myDispatcher = dispatcher;
        this.myFuture = future2;
        this.myService = service;
        this.myProxyDispatcher = new MyProxyDispatcher();
    }

    public void callNotify(final ChangeListCommand command) {
        this.myFuture.set(this.myService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    command.doNotify((EventDispatcher<ChangeListListener>)DelayedNotificator.this.myDispatcher);
                }
                catch (Throwable e2) {
                    LOG.error(e2);
                }
            }
        }));
    }

    public ChangeListListener getProxyDispatcher() {
        return this.myProxyDispatcher;
    }

    private class MyProxyDispatcher
    implements ChangeListListener {
        private MyProxyDispatcher() {
        }

        public void changeListAdded(final ChangeList list2) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListAdded(list2);
                }
            }));
        }

        public void changesRemoved(final Collection<Change> changes, final ChangeList fromList) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changesRemoved(changes, fromList);
                }
            }));
        }

        public void changesAdded(final Collection<Change> changes, final ChangeList toList) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changesAdded(changes, toList);
                }
            }));
        }

        public void changeListRemoved(final ChangeList list2) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListRemoved(list2);
                }
            }));
        }

        public void changeListChanged(final ChangeList list2) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListChanged(list2);
                }
            }));
        }

        public void changeListRenamed(final ChangeList list2, final String oldName) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListRenamed(list2, oldName);
                }
            }));
        }

        public void changeListCommentChanged(final ChangeList list2, final String oldComment) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListCommentChanged(list2, oldComment);
                }
            }));
        }

        public void changesMoved(final Collection<Change> changes, final ChangeList fromList, final ChangeList toList) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changesMoved(changes, fromList, toList);
                }
            }));
        }

        public void defaultListChanged(final ChangeList oldDefaultList, final ChangeList newDefaultList) {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).defaultListChanged(oldDefaultList, newDefaultList);
                }
            }));
        }

        public void unchangedFileStatusChanged() {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).unchangedFileStatusChanged();
                }
            }));
        }

        public void changeListUpdateDone() {
            DelayedNotificator.this.myFuture.set(DelayedNotificator.this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListUpdateDone();
                }
            }));
        }
    }
}

