/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class HierarchicalFilePathComparator
implements Comparator<FilePath> {
    public static final HierarchicalFilePathComparator IGNORE_CASE = new HierarchicalFilePathComparator(true);
    public static final HierarchicalFilePathComparator SYSTEM_CASE_SENSITIVE = new HierarchicalFilePathComparator(SystemInfo.isFileSystemCaseSensitive);
    private final boolean myIgnoreCase;

    private HierarchicalFilePathComparator(boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public int compare(@NotNull FilePath filePath1, @NotNull FilePath filePath2) {
        boolean isDirectory2;
        char c2;
        char c1;
        int index2;
        if (filePath1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath1", "com/intellij/openapi/vcs/changes/HierarchicalFilePathComparator", "compare"));
        }
        if (filePath2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath2", "com/intellij/openapi/vcs/changes/HierarchicalFilePathComparator", "compare"));
        }
        String path1 = FileUtilRt.toSystemIndependentName((String)filePath1.getPath());
        String path2 = FileUtilRt.toSystemIndependentName((String)filePath2.getPath());
        int index1 = 0;
        int start2 = 0;
        for (index2 = 0; index1 < path1.length() && index2 < path2.length() && StringUtil.compare((char)(c1 = path1.charAt(index1)), (char)(c2 = path2.charAt(index2)), (boolean)this.myIgnoreCase) == 0; ++index1, ++index2) {
            if (c1 != '/') continue;
            start2 = index1;
        }
        if (index1 == path1.length() && index2 == path2.length()) {
            return 0;
        }
        if (index1 == path1.length()) {
            return -1;
        }
        if (index2 == path2.length()) {
            return 1;
        }
        int end1 = path1.indexOf(47, start2 + 1);
        int end2 = path2.indexOf(47, start2 + 1);
        String name1 = end1 == -1 ? path1.substring(start2) : path1.substring(start2, end1);
        String name2 = end2 == -1 ? path2.substring(start2) : path2.substring(start2, end2);
        boolean isDirectory1 = end1 != -1 || filePath1.isDirectory();
        boolean bl = isDirectory2 = end2 != -1 || filePath2.isDirectory();
        if (isDirectory1 && !isDirectory2) {
            return -1;
        }
        if (!isDirectory1 && isDirectory2) {
            return 1;
        }
        return StringUtil.compare((String)name1, (String)name2, (boolean)this.myIgnoreCase);
    }
}

