/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastUnchangedContentTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.LastUnchangedContentTracker");
    private static final Key<Long> LAST_TS_KEY = Key.create((String)"LAST_TS_KEY");
    private static final FileAttribute LAST_TS_ATTR = new FileAttribute("LAST_TS_ATTR", 0, true);
    private static final FileAttribute ACQUIRED_CONTENT_ATTR = new FileAttribute("ACQUIRED_CONTENT_ATTR", 1, true);
    private static final Key<Boolean> VCS_INVALID_FILE_STATUS = Key.create((String)"VCS_INVALID_FILE_STATUS");

    public static void updateLastUnchangedContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker", "updateLastUnchangedContent"));
        }
        if (LastUnchangedContentTracker.isTouched(file2)) {
            return;
        }
        Long lastTs = LastUnchangedContentTracker.getLastSavedStamp(file2);
        long stamp = file2.getTimeStamp();
        if (lastTs != null && stamp == lastTs) {
            return;
        }
        Integer oldContentId = LastUnchangedContentTracker.getSavedContentId(file2);
        if (oldContentId != null && oldContentId > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releasing content for " + file2 + ", id = " + oldContentId);
            }
            LastUnchangedContentTracker.getFS().releaseContent(oldContentId);
        }
        LastUnchangedContentTracker.saveContentReference(file2, LastUnchangedContentTracker.getFS().acquireContent(file2));
        LastUnchangedContentTracker.markTouched(file2);
    }

    private static boolean isTouched(VirtualFile file2) {
        return Boolean.TRUE.equals(file2.getUserData(VCS_INVALID_FILE_STATUS));
    }

    public static void markTouched(VirtualFile file2) {
        file2.putUserData(VCS_INVALID_FILE_STATUS, (Object)Boolean.TRUE);
    }

    public static void markUntouched(VirtualFile file2) {
        file2.putUserData(VCS_INVALID_FILE_STATUS, null);
    }

    @Nullable
    public static byte[] getLastUnchangedContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker", "getLastUnchangedContent"));
        }
        Integer id = LastUnchangedContentTracker.getSavedContentId(file2);
        try {
            return id == null ? null : LastUnchangedContentTracker.getFS().contentsToByteArray(id);
        }
        catch (IOException e2) {
            LOG.info((Throwable)e2);
            return null;
        }
    }

    private static PersistentFS getFS() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveContentReference(VirtualFile file2, int contentId) {
        if (contentId == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saveContentReference without content for file = " + file2);
            }
            return;
        }
        LOG.assertTrue(contentId > 0, (Object)contentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveContentReference file = " + file2 + ", id = " + contentId);
        }
        long stamp = file2.getTimeStamp();
        try {
            try (DataOutputStream contentStream = ACQUIRED_CONTENT_ATTR.writeAttribute(file2);){
                contentStream.writeInt(contentId);
            }
            try (DataOutputStream tsStream = LAST_TS_ATTR.writeAttribute(file2);){
                tsStream.writeLong(stamp);
            }
            file2.putUserData(LAST_TS_KEY, (Object)stamp);
        }
        catch (IOException e2) {
            LOG.info((Throwable)e2);
        }
    }

    public static boolean hasSavedContent(VirtualFile file2) {
        return LastUnchangedContentTracker.getSavedContentId(file2) != null;
    }

    public static void forceSavedContent(VirtualFile file2, @NotNull String content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker", "forceSavedContent"));
        }
        LastUnchangedContentTracker.saveContentReference(file2, LastUnchangedContentTracker.getFS().storeUnlinkedContent(content2.getBytes(file2.getCharset())));
    }

    @Nullable
    private static Integer getSavedContentId(VirtualFile file2) {
        Integer oldContentId;
        block8: {
            if (!file2.isValid()) {
                return null;
            }
            oldContentId = null;
            try {
                DataInputStream stream = ACQUIRED_CONTENT_ATTR.readAttribute(file2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getSavedContentId for " + file2 + "; stream=" + stream);
                }
                if (stream == null) break block8;
                try {
                    oldContentId = stream.readInt();
                }
                finally {
                    stream.close();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("oldContentId=" + oldContentId);
                }
                LOG.assertTrue(oldContentId > 0, (Object)oldContentId);
            }
            catch (IOException e2) {
                LOG.info((Throwable)e2);
            }
        }
        return oldContentId;
    }

    @Nullable
    private static Long getLastSavedStamp(VirtualFile file2) {
        Long l2;
        block6: {
            l2 = (Long)file2.getUserData(LAST_TS_KEY);
            if (l2 == null) {
                try {
                    DataInputStream stream = LAST_TS_ATTR.readAttribute(file2);
                    if (stream == null) break block6;
                    try {
                        l2 = stream.readLong();
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    LOG.info((Throwable)e2);
                }
            }
        }
        return l2;
    }
}

