/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LazyRefreshingSelfQueue<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.LazyRefreshingSelfQueue");
    private final Getter<Long> myUpdateInterval;
    private final LinkedList<Pair<Long, T>> myQueue;
    private final Set<T> myInProgress;
    private final Computable<Boolean> myShouldUpdateOldChecker;
    private final Consumer<T> myUpdater;
    private final Object myLock;

    public LazyRefreshingSelfQueue(Getter<Long> updateInterval, Computable<Boolean> shouldUpdateOldChecker, Consumer<T> updater) {
        this.myUpdateInterval = updateInterval;
        this.myShouldUpdateOldChecker = shouldUpdateOldChecker;
        this.myUpdater = updater;
        this.myQueue = new LinkedList();
        this.myInProgress = new HashSet<T>();
        this.myLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(@NotNull T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/vcs/changes/LazyRefreshingSelfQueue", "addRequest"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.addFirst(new Pair(null, t2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRemove(@NotNull T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/vcs/changes/LazyRefreshingSelfQueue", "forceRemove"));
        }
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator2 = this.myQueue.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                if (!t2.equals(pair.getSecond())) continue;
                iterator2.remove();
            }
            this.myInProgress.remove(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStep() {
        long startTime = System.currentTimeMillis() - (Long)this.myUpdateInterval.get();
        boolean onlyAbsolute = true;
        Object object = this.myLock;
        synchronized (object) {
            for (Pair iterator2 : this.myQueue) {
                if (iterator2.getFirst() == null) continue;
                onlyAbsolute = (Long)iterator2.getFirst() > startTime;
                break;
            }
        }
        Boolean shouldUpdateOld = onlyAbsolute ? Boolean.valueOf(false) : (Boolean)this.myShouldUpdateOldChecker.compute();
        LinkedList<Object> dirty = new LinkedList<Object>();
        Object object2 = this.myLock;
        synchronized (object2) {
            Pair<Long, T> pair;
            while (!this.myQueue.isEmpty() && (pair = this.myQueue.get(0)).getFirst() == null) {
                dirty.add(this.myQueue.removeFirst().getSecond());
            }
            if (Boolean.TRUE.equals(shouldUpdateOld) && !this.myQueue.isEmpty()) {
                Pair<Long, T> pair2;
                while (!this.myQueue.isEmpty() && (Long)(pair2 = this.myQueue.get(0)).getFirst() < startTime) {
                    this.myQueue.removeFirst();
                    dirty.add(pair2.getSecond());
                }
            }
            this.myInProgress.addAll(dirty);
        }
        LOG.debug("found something to update: " + !dirty.isEmpty());
        for (Object e2 : dirty) {
            this.myUpdater.consume(e2);
            Object object3 = this.myLock;
            synchronized (object3) {
                if (this.myInProgress.remove(e2)) {
                    this.myQueue.addLast(new Pair((Object)System.currentTimeMillis(), e2));
                }
            }
        }
    }
}

