/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.TodoForRanges;
import com.intellij.openapi.vcs.changes.TodoItemData;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;

public class TodoForBaseRevision
extends TodoForRanges {
    private final Getter<Object> myGetter;
    private final Consumer<Object> mySaver;

    public TodoForBaseRevision(Project project2, List<TextRange> ranges, int additionalOffset, String name, String text2, boolean revision, FileType type, Getter<Object> cacheGetter, Consumer<Object> cacheSaver) {
        super(project2, ranges, additionalOffset, name, text2, revision, type);
        this.myGetter = cacheGetter;
        this.mySaver = cacheSaver;
    }

    @Override
    protected TodoItemData[] getTodoItems() {
        TodoItemData[] items2 = (TodoItemData[])this.myGetter.get();
        if (items2 != null) {
            return items2;
        }
        TodoItem[] todoItems = this.getTodoForText(PsiTodoSearchHelper.SERVICE.getInstance((Project)this.myProject));
        if (todoItems != null) {
            TodoItemData[] arr = TodoForBaseRevision.convertTodo(todoItems);
            this.mySaver.consume((Object)arr);
            return arr;
        }
        return null;
    }

    public static TodoItemData[] convertTodo(TodoItem[] todoItems) {
        ArrayList<TodoItemData> list2 = new ArrayList<TodoItemData>();
        for (TodoItem item : todoItems) {
            TextRange range = item.getTextRange();
            TodoItemData data = new TodoItemData(range.getStartOffset(), range.getEndOffset(), item.getPattern());
            list2.add(data);
        }
        return list2.toArray(new TodoItemData[list2.size()]);
    }
}

