/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFileHolder
implements FileHolder {
    private final Set<VirtualFile> myFiles = new HashSet<VirtualFile>();
    private final Project myProject;
    private final FileHolder.HolderType myType;

    public VirtualFileHolder(Project project2, FileHolder.HolderType type) {
        this.myProject = project2;
        this.myType = type;
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myType;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs vcs) {
    }

    @Override
    public void cleanAll() {
        this.myFiles.clear();
    }

    static int cleanScope(final Project project2, final Collection<VirtualFile> files2, final VcsModifiableDirtyScope scope) {
        return (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

            public Integer compute() {
                int result2;
                block7: {
                    block6: {
                        result2 = 0;
                        if (project2.isDisposed() || files2.isEmpty()) {
                            return 0;
                        }
                        if (scope.getRecursivelyDirtyDirectories().size() != 0) break block6;
                        Set dirtyFiles = scope.getDirtyFiles();
                        boolean cleanDroppedFiles = false;
                        for (FilePath dirtyFile : dirtyFiles) {
                            VirtualFile f2 = dirtyFile.getVirtualFile();
                            if (f2 != null) {
                                if (!files2.remove(f2) || !f2.isDirectory()) continue;
                                ++result2;
                                continue;
                            }
                            cleanDroppedFiles = true;
                        }
                        if (!cleanDroppedFiles) break block7;
                        Iterator iterator2 = files2.iterator();
                        while (iterator2.hasNext()) {
                            VirtualFile file2 = (VirtualFile)iterator2.next();
                            if (!VirtualFileHolder.fileDropped(file2)) continue;
                            iterator2.remove();
                            scope.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file2));
                            if (!file2.isDirectory()) continue;
                            ++result2;
                        }
                        break block7;
                    }
                    Iterator iterator3 = files2.iterator();
                    while (iterator3.hasNext()) {
                        VirtualFile file3 = (VirtualFile)iterator3.next();
                        boolean fileDropped = VirtualFileHolder.fileDropped(file3);
                        if (fileDropped) {
                            scope.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file3));
                        }
                        if (!fileDropped && !scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file3))) continue;
                        iterator3.remove();
                        if (!file3.isDirectory()) continue;
                        ++result2;
                    }
                }
                return result2;
            }
        });
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        VirtualFileHolder.cleanScope(this.myProject, this.myFiles, scope);
    }

    private static boolean fileDropped(VirtualFile file2) {
        return !file2.isValid();
    }

    public void addFile(VirtualFile file2) {
        this.myFiles.add(file2);
    }

    public void removeFile(VirtualFile file2) {
        this.myFiles.remove(file2);
    }

    @NotNull
    public List<VirtualFile> getFiles() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myFiles);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VirtualFileHolder", "getFiles"));
        }
        return arrayList;
    }

    @Override
    public VirtualFileHolder copy() {
        VirtualFileHolder copyHolder = new VirtualFileHolder(this.myProject, this.myType);
        copyHolder.myFiles.addAll(this.myFiles);
        return copyHolder;
    }

    public boolean containsFile(VirtualFile file2) {
        return this.myFiles.contains(file2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VirtualFileHolder that = (VirtualFileHolder)o2;
        return this.myFiles.equals(that.myFiles);
    }

    public int hashCode() {
        return this.myFiles.hashCode();
    }
}

