/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreatePatchFromChangesAction
extends AnAction
implements DumbAware {
    public CreatePatchFromChangesAction() {
        super(VcsBundle.message((String)"action.name.create.patch.for.selected.revisions", (Object[])new Object[0]), VcsBundle.message((String)"action.description.create.patch.for.selected.revisions", (Object[])new Object[0]), AllIcons.Actions.CreatePatch);
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e2.getData(VcsDataKeys.CHANGES);
        if (changes == null || changes.length == 0) {
            return;
        }
        String commitMessage = null;
        List<ShelvedChangeList> shelvedChangeLists = ShelvedChangesViewManager.getShelvedLists(e2.getDataContext());
        if (!shelvedChangeLists.isEmpty()) {
            commitMessage = shelvedChangeLists.get((int)0).DESCRIPTION;
        } else {
            ChangeList[] changeLists = (ChangeList[])e2.getData(VcsDataKeys.CHANGE_LISTS);
            if (changeLists != null && changeLists.length > 0) {
                commitMessage = changeLists[0].getComment();
            }
        }
        if (commitMessage == null) {
            commitMessage = (String)e2.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        }
        if (commitMessage == null) {
            commitMessage = "";
        }
        ArrayList<Change> changeCollection = new ArrayList<Change>();
        Collections.addAll(changeCollection, changes);
        CreatePatchFromChangesAction.createPatch(project2, commitMessage, changeCollection);
    }

    public static void createPatch(Project project2, String commitMessage, List<Change> changeCollection) {
        SessionDialog sessionDialog;
        CreatePatchCommitExecutor executor2 = CreatePatchCommitExecutor.getInstance(project2 = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2);
        CommitSession commitSession = executor2.createCommitSession();
        if (commitSession instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)commitSession).setContext(new CommitContext());
        }
        if (!(sessionDialog = new SessionDialog(executor2.getActionText(), project2, commitSession, changeCollection, commitMessage)).showAndGet()) {
            return;
        }
        CreatePatchFromChangesAction.preloadContent(project2, changeCollection);
        commitSession.execute(changeCollection, commitMessage);
    }

    private static void preloadContent(Project project2, final List<Change> changes) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (Change change : changes) {
                    this.checkLoadContent(change.getBeforeRevision());
                    this.checkLoadContent(change.getAfterRevision());
                }
            }

            private void checkLoadContent(ContentRevision revision) {
                ProgressManager.checkCanceled();
                if (revision != null && !(revision instanceof BinaryContentRevision)) {
                    try {
                        revision.getContent();
                    }
                    catch (VcsException vcsException) {
                        // empty catch block
                    }
                }
            }
        }, VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true, project2);
    }

    public void update(AnActionEvent e2) {
        Change[] changes;
        Boolean haveSelectedChanges = (Boolean)e2.getData(VcsDataKeys.HAVE_SELECTED_CHANGES);
        ChangeList[] changeLists = (ChangeList[])e2.getData(VcsDataKeys.CHANGE_LISTS);
        List<ShelvedChangeList> shelveChangelists = ShelvedChangesViewManager.getShelvedLists(e2.getDataContext());
        int changelistNum = changeLists == null ? 0 : changeLists.length;
        e2.getPresentation().setEnabled(Boolean.TRUE.equals(haveSelectedChanges) && (changelistNum += shelveChangelists.size()) == 1 && (changes = (Change[])e2.getData(VcsDataKeys.CHANGES)) != null && changes.length > 0);
    }
}

