/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EditAction
extends AnAction {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        List files2 = (List)e2.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        EditAction.editFilesAndShowErrors(project2, files2);
    }

    public static void editFilesAndShowErrors(Project project2, List<VirtualFile> files2) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        EditAction.editFiles(project2, files2, exceptions);
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project2).showErrors(exceptions, VcsBundle.message((String)"edit.errors", (Object[])new Object[0]));
        }
    }

    public static void editFiles(Project project2, List<VirtualFile> files2, List<VcsException> exceptions) {
        ChangesUtil.processVirtualFilesByVcs((Project)project2, files2, (vcs, items2) -> {
            EditFileProvider provider = vcs.getEditFileProvider();
            if (provider != null) {
                try {
                    provider.editFiles(VfsUtil.toVirtualFileArray((Collection)items2));
                }
                catch (VcsException e1) {
                    exceptions.add(e1);
                }
                for (VirtualFile file2 : items2) {
                    VcsDirtyScopeManager.getInstance((Project)project2).fileDirty(file2);
                    FileStatusManager.getInstance((Project)project2).fileStatusChanged(file2);
                }
            }
        });
    }

    public void update(AnActionEvent e2) {
        List files2 = (List)e2.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        boolean enabled = files2 != null && !files2.isEmpty();
        e2.getPresentation().setEnabled(enabled);
        e2.getPresentation().setVisible(enabled);
    }
}

