/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class RefreshAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        RefreshAction.doRefresh(project2);
    }

    public static void doRefresh(final Project project2) {
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RefreshAction.invokeCustomRefreshes(project2);
        VirtualFileManager.getInstance().asyncRefresh(new Runnable(){

            @Override
            public void run() {
                if (!project2.isDisposed()) {
                    VcsDirtyScopeManager.getInstance((Project)project2).markEverythingDirty();
                }
            }
        });
    }

    private static void invokeCustomRefreshes(@NotNull Project project2) {
        ChangesViewRefresher[] extensions;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/RefreshAction", "invokeCustomRefreshes"));
        }
        for (ChangesViewRefresher refresher : extensions = (ChangesViewRefresher[])ChangesViewRefresher.EP_NAME.getExtensions((AreaInstance)project2)) {
            refresher.refresh(project2);
        }
    }
}

