/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveChangeListAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction", "update"));
        }
        boolean visible = RemoveChangeListAction.canRemoveChangeLists(e2.getProject(), (ChangeList[])e2.getData(VcsDataKeys.CHANGE_LISTS));
        e2.getPresentation().setEnabled(visible);
        if (e2.getPlace().equals("ChangesViewPopup")) {
            e2.getPresentation().setVisible(visible);
        }
    }

    private static boolean canRemoveChangeLists(@Nullable Project project2, @Nullable ChangeList[] lists) {
        if (project2 == null || lists == null || lists.length == 0) {
            return false;
        }
        int allChangeListsCount = ChangeListManager.getInstance((Project)project2).getChangeListsNumber();
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            LocalChangeList localChangeList = (LocalChangeList)changeList;
            if (localChangeList.isReadOnly()) {
                return false;
            }
            if (!localChangeList.isDefault() || allChangeListsCount > lists.length) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction", "actionPerformed"));
        }
        final Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        ChangeList[] selectedLists = (ChangeList[])e2.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        ChangeListRemoveConfirmation.processLists(project2, true, Arrays.asList(selectedLists), new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> lists) {
                if (lists == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction$1", "askIfShouldRemoveChangeLists"));
                }
                return RemoveChangeListAction.askIfShouldRemoveChangeLists(lists, project2);
            }
        });
    }

    private static boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> lists, Project project2) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction", "askIfShouldRemoveChangeLists"));
        }
        for (LocalChangeList localChangeList : lists) {
            if (!localChangeList.isDefault()) continue;
            return RemoveChangeListAction.confirmActiveChangeListRemoval(project2, lists, localChangeList.getChanges().isEmpty());
        }
        boolean haveNoChanges = lists.stream().noneMatch(list2 -> !list2.getChanges().isEmpty());
        String string2 = lists.size() == 1 ? VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{lists.get(0).getName()}) : VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.size()});
        return haveNoChanges || 0 == Messages.showYesNoDialog((Project)project2, (String)string2, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
    }

    static boolean confirmActiveChangeListRemoval(@NotNull Project project2, @NotNull List<? extends LocalChangeList> lists, boolean empty) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction", "confirmActiveChangeListRemoval"));
        }
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction", "confirmActiveChangeListRemoval"));
        }
        List remainingLists = ChangeListManager.getInstance((Project)project2).getChangeListsCopy();
        remainingLists.removeAll(lists);
        String[] remainingListsNames = (String[])remainingLists.stream().map(ChangeList::getName).toArray(String[]::new);
        int nameIndex = Messages.showChooseDialog((Project)project2, (String)(empty ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0])), (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])remainingListsNames, (String)remainingListsNames[0]);
        if (nameIndex < 0) {
            return false;
        }
        ChangeListManager.getInstance((Project)project2).setDefaultChangeList((LocalChangeList)remainingLists.get(nameIndex));
        return true;
    }
}

