/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.actions.RevertCommittedStuffAbstractAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.Convertor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RevertSelectedChangesAction
extends RevertCommittedStuffAbstractAction {
    private static Icon ourIcon;
    private static String ourText;

    @Override
    public void update(AnActionEvent e2) {
        Presentation presentation = e2.getPresentation();
        RevertSelectedChangesAction.initPresentation();
        presentation.setIcon(ourIcon);
        presentation.setText(ourText);
        super.update(e2);
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/RevertSelectedChangesAction", "isEnabled"));
        }
        return super.isEnabled(e2) && RevertSelectedChangesAction.allSelectedChangeListsAreRevertable(e2);
    }

    private static boolean allSelectedChangeListsAreRevertable(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/RevertSelectedChangesAction", "allSelectedChangeListsAreRevertable"));
        }
        ChangeList[] changeLists = (ChangeList[])e2.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists == null) {
            return true;
        }
        for (ChangeList list2 : changeLists) {
            if (!(list2 instanceof CommittedChangeList) || ((CommittedChangeList)list2).isModifiable()) continue;
            return false;
        }
        return true;
    }

    private static void initPresentation() {
        if (ourIcon == null) {
            ourIcon = AllIcons.Actions.Rollback;
            ourText = VcsBundle.message((String)"action.revert.selected.changes.text", (Object[])new Object[0]);
        }
    }

    public RevertSelectedChangesAction() {
        super(new Convertor<AnActionEvent, Change[]>(){

            public Change[] convert(AnActionEvent e2) {
                return (Change[])e2.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
            }
        }, new Convertor<AnActionEvent, Change[]>(){

            public Change[] convert(AnActionEvent e2) {
                e2.getData(VcsDataKeys.CHANGES_WITH_MOVED_CHILDREN);
                return (Change[])e2.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
            }
        });
    }
}

