/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "update"));
        }
        boolean enabled = e2.getProject() != null && !UtilKt.isEmpty(this.getUnversionedFiles(e2, e2.getProject()));
        e2.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e2.getPlace()) || "ChangesViewPopup".equals(e2.getPlace())) {
            e2.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "actionPerformed"));
        }
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e2, project2).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project2, unversionedFiles, (Condition<FileStatus>)((Condition)this::isStatusForAddition), (ChangesBrowserBase)e2.getData(ChangesBrowserBase.DATA_KEY));
    }

    public static boolean addUnversioned(@NotNull Project project2, @NotNull List<VirtualFile> files2, @NotNull Condition<FileStatus> unversionedFileCondition, @Nullable ChangesBrowserBase browser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        if (unversionedFileCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unversionedFileCondition", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        boolean result2 = true;
        if (!files2.isEmpty()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Consumer consumer2 = browser == null ? null : changes -> {
                if (files2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "lambda$addUnversioned$0"));
                }
                browser.rebuildList();
                browser.getViewer().excludeChanges(files2);
                browser.getViewer().includeChanges(changes);
            };
            ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project2);
            LocalChangeList targetChangeList = browser == null ? manager.getDefaultChangeList() : (LocalChangeList)browser.getSelectedChangeList();
            List<VcsException> exceptions = manager.addUnversionedFiles(targetChangeList, files2, unversionedFileCondition, (Consumer<List<Change>>)consumer2);
            result2 = exceptions.isEmpty();
        }
        return result2;
    }

    @NotNull
    private Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e2, @NotNull Project project2) {
        boolean hasExplicitUnversioned;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        boolean bl = hasExplicitUnversioned = !UtilKt.isEmpty((Stream)e2.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY));
        Stream<VirtualFile> stream = hasExplicitUnversioned ? (Stream<VirtualFile>)e2.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY) : (this.checkVirtualFiles(e2) ? UtilKt.notNullize((Stream)e2.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)).filter(file2 -> this.isFileUnversioned((VirtualFile)file2, vcsManager, fileStatusManager)) : Stream.empty());
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        return stream;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (fileStatusManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatusManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.UNKNOWN;
    }

    protected boolean checkVirtualFiles(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "checkVirtualFiles"));
        }
        return ArrayUtil.isEmpty((Object[])((Object[])e2.getData(VcsDataKeys.CHANGES)));
    }
}

