/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ShowDiffAction.class);

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "update"));
        }
        Change[] changes = (Change[])e2.getData(VcsDataKeys.CHANGES);
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if ("MainMenu".equals(e2.getPlace())) {
            e2.getPresentation().setEnabled(project2 != null && changes != null && changes.length > 0);
        } else {
            e2.getPresentation().setEnabled(project2 != null && ShowDiffAction.canShowDiff(project2, changes));
        }
    }

    public static boolean canShowDiff(@Nullable Project project2, @Nullable Change[] changes) {
        return changes != null && ShowDiffAction.canShowDiff(project2, Arrays.asList(changes));
    }

    public static boolean canShowDiff(@Nullable Project project2, @Nullable List<Change> changes) {
        if (changes == null || changes.size() == 0) {
            return false;
        }
        for (Change change : changes) {
            if (!ChangeDiffRequestProducer.canCreate(project2, change)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "actionPerformed"));
        }
        final Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        final Change[] changes = (Change[])e2.getData(VcsDataKeys.CHANGES);
        if (project2 == null || !ShowDiffAction.canShowDiff(project2, changes)) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        final boolean needsConversion = ShowDiffAction.checkIfThereAreFakeRevisions(project2, changes);
        final List changesInList = (List)e2.getData(VcsDataKeys.CHANGES_IN_LIST_KEY);
        Runnable performer = new Runnable(){

            @Override
            public void run() {
                Object[] convertedChanges = needsConversion ? ShowDiffAction.loadFakeRevisions(project2, changes) : changes;
                if (convertedChanges == null || convertedChanges.length == 0) {
                    return;
                }
                Change selectedChane = null;
                List result2 = null;
                if (convertedChanges.length == 1) {
                    selectedChane = convertedChanges[0];
                    LocalChangeList changeList = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)project2)).getIdentityChangeList(selectedChane);
                    if (changeList != null) {
                        List list2 = result2 = changesInList != null ? changesInList : new ArrayList(changeList.getChanges());
                    }
                }
                if (result2 == null) {
                    result2 = ContainerUtil.newArrayList((Object[])convertedChanges);
                }
                int index = selectedChane == null ? 0 : Math.max(0, ContainerUtil.indexOfIdentity((List)result2, (Object)selectedChane));
                ShowDiffAction.showDiffForChange(project2, result2, index);
            }
        };
        if (needsConversion) {
            ChangeListManager.getInstance((Project)project2).invokeAfterUpdate(performer, InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, ActionsBundle.actionText((String)"ChangesView.Diff"), ModalityState.current());
        } else {
            performer.run();
        }
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project2, @NotNull Change[] changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "checkIfThereAreFakeRevisions"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "checkIfThereAreFakeRevisions"));
        }
        boolean needsConversion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project2).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project2).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @Nullable
    private static Change[] loadFakeRevisions(@NotNull Project project2, @NotNull Change[] changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "loadFakeRevisions"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "loadFakeRevisions"));
        }
        ArrayList matchingChanges = new ArrayList();
        for (Change change : changes) {
            matchingChanges.addAll(ChangeListManager.getInstance((Project)project2).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        return matchingChanges.toArray(new Change[matchingChanges.size()]);
    }

    public static void showDiffForChange(@Nullable Project project2, @NotNull Iterable<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        ShowDiffAction.showDiffForChange(project2, changes, 0);
    }

    public static void showDiffForChange(@Nullable Project project2, @NotNull Iterable<Change> changes, int index) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        ShowDiffAction.showDiffForChange(project2, changes, index, new ShowDiffContext());
    }

    public static void showDiffForChange(@Nullable Project project2, @NotNull Iterable<Change> changes, @NotNull Condition<Change> condition, @NotNull ShowDiffContext context2) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        int index = 0;
        ArrayList<ChangeDiffRequestProducer> presentables = new ArrayList<ChangeDiffRequestProducer>();
        for (Change change : changes) {
            ChangeDiffRequestProducer presentable;
            if (condition.value((Object)change)) {
                index = presentables.size();
            }
            if ((presentable = ChangeDiffRequestProducer.create(project2, change, context2.getChangeContext(change))) == null) continue;
            presentables.add(presentable);
        }
        ShowDiffAction.showDiffForChange(project2, presentables, index, context2);
    }

    public static void showDiffForChange(@Nullable Project project2, @NotNull Iterable<Change> changes, int index, @NotNull ShowDiffContext context2) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        int i2 = 0;
        int newIndex = 0;
        ArrayList<ChangeDiffRequestProducer> presentables = new ArrayList<ChangeDiffRequestProducer>();
        for (Change change : changes) {
            ChangeDiffRequestProducer presentable;
            if (i2 == index) {
                newIndex = presentables.size();
            }
            if ((presentable = ChangeDiffRequestProducer.create(project2, change, context2.getChangeContext(change))) != null) {
                presentables.add(presentable);
            }
            ++i2;
        }
        ShowDiffAction.showDiffForChange(project2, presentables, newIndex, context2);
    }

    private static void showDiffForChange(@Nullable Project project2, @NotNull List<ChangeDiffRequestProducer> presentables, int index, @NotNull ShowDiffContext context2) {
        if (presentables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentables", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffAction", "showDiffForChange"));
        }
        if (presentables.isEmpty()) {
            return;
        }
        if (index < 0 || index >= presentables.size()) {
            index = 0;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(presentables);
        chain.setIndex(index);
        for (Map.Entry<Key, Object> entry : context2.getChainContext().entrySet()) {
            chain.putUserData(entry.getKey(), entry.getValue());
        }
        chain.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, context2.getActions());
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)chain, context2.getDialogHints());
    }
}

