/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.external.BinaryDiffTool;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.vcs.changes.actions.migrate.MigrateToNewDiffUtil;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

public class MigrateDiffTool
implements DiffTool {
    public static final MigrateDiffTool INSTANCE = new MigrateDiffTool();

    private MigrateDiffTool() {
    }

    public void show(DiffRequest request2) {
        DiffRequestChain newChain = MigrateToNewDiffUtil.convertRequestChain(request2);
        WindowWrapper.Mode mode = FrameDiffTool.shouldOpenDialog(request2.getHints()) ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        DiffManager.getInstance().showDiff(request2.getProject(), newChain, new DiffDialogHints(mode));
    }

    public boolean canShow(DiffRequest request2) {
        if (request2 instanceof MergeRequest) {
            return false;
        }
        if (request2.getContents().length != 2) {
            return false;
        }
        if (request2.getHints().contains(MigrateToNewDiffUtil.DO_NOT_TRY_MIGRATE)) {
            return false;
        }
        if (request2.getOnOkRunnable() != null) {
            return false;
        }
        if (!DiffManagerImpl.INTERNAL_DIFF.canShow(request2) && !BinaryDiffTool.INSTANCE.canShow(request2)) {
            return false;
        }
        for (DiffTool tool : DiffManagerImpl.getInstanceEx().getAdditionTools()) {
            if (tool == this || !tool.canShow(request2)) continue;
            return false;
        }
        return true;
    }

    public DiffViewer createComponent(String title, DiffRequest request2, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateDiffTool", "createComponent"));
        }
        return null;
    }
}

