/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;

public class CommittedChangesTableModel
extends ListTableModel<CommittedChangeList> {
    private final boolean myAsynchLoad;
    private static final ChangeListColumn[] ourDefaultColumns = new ChangeListColumn[]{ChangeListColumn.DATE, ChangeListColumn.NAME};
    private RowSorter.SortKey mySortKey;

    public CommittedChangesTableModel(List<CommittedChangeList> changeLists, boolean asynchLoad) {
        super(CommittedChangesTableModel.buildColumnInfos(ourDefaultColumns), changeLists, 0);
        this.myAsynchLoad = asynchLoad;
    }

    public CommittedChangesTableModel(List<CommittedChangeList> changeLists, ChangeListColumn[] columns, boolean asynchLoad) {
        super(CommittedChangesTableModel.buildColumnInfos(columns), changeLists, 0);
        this.myAsynchLoad = asynchLoad;
    }

    protected void setSortKey(RowSorter.SortKey sortKey) {
        this.mySortKey = sortKey;
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return this.mySortKey;
    }

    private static ColumnInfo[] buildColumnInfos(ChangeListColumn[] columns) {
        ColumnInfo[] result2 = new ColumnInfo[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            result2[i2] = new ColumnInfoAdapter(columns[i2]);
        }
        return result2;
    }

    public boolean isAsynchLoad() {
        return this.myAsynchLoad;
    }

    private static class ColumnInfoAdapter
    extends ColumnInfo {
        private final ChangeListColumn myColumn;

        public ColumnInfoAdapter(ChangeListColumn column) {
            super(column.getTitle());
            this.myColumn = column;
        }

        public Object valueOf(Object o2) {
            return this.myColumn.getValue((ChangeList)o2);
        }

        public Comparator getComparator() {
            return this.myColumn.getComparator();
        }

        public ChangeListColumn getColumn() {
            return this.myColumn;
        }
    }
}

