/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommittedListsSequencesZipper {
    @NotNull
    private final VcsCommittedListsZipper myVcsPartner;
    @NotNull
    private final List<RepositoryLocation> myInLocations;
    @NotNull
    private final Map<String, List<CommittedChangeList>> myInLists;
    @NotNull
    private final Comparator<CommittedChangeList> myComparator;

    public CommittedListsSequencesZipper(@NotNull VcsCommittedListsZipper vcsPartner) {
        if (vcsPartner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsPartner", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "<init>"));
        }
        this.myVcsPartner = vcsPartner;
        this.myInLocations = ContainerUtil.newArrayList();
        this.myInLists = ContainerUtil.newHashMap();
        this.myComparator = new Comparator<CommittedChangeList>(){

            @Override
            public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                return Comparing.compare((long)CommittedListsSequencesZipper.this.myVcsPartner.getNumber(o1), (long)CommittedListsSequencesZipper.this.myVcsPartner.getNumber(o2));
            }
        };
    }

    public void add(@NotNull RepositoryLocation location, @NotNull List<CommittedChangeList> lists) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "add"));
        }
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "add"));
        }
        this.myInLocations.add(location);
        Collections.sort(lists, this.myComparator);
        this.myInLists.put(location.toPresentableString(), lists);
    }

    @NotNull
    public List<CommittedChangeList> execute() {
        Pair groupingResult = this.myVcsPartner.groupLocations(this.myInLocations);
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(ContainerUtil.flatten(this.collectChangeLists((List)groupingResult.getSecond())));
        for (RepositoryLocationGroup group : (List)groupingResult.getFirst()) {
            result2.addAll(this.mergeLocationGroupChangeLists(group));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "execute"));
        }
        return arrayList;
    }

    @NotNull
    private List<List<CommittedChangeList>> collectChangeLists(@NotNull List<RepositoryLocation> locations) {
        if (locations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locations", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "collectChangeLists"));
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)locations.size());
        for (RepositoryLocation location : locations) {
            result2.add(this.myInLists.get(location.toPresentableString()));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "collectChangeLists"));
        }
        return arrayList;
    }

    @NotNull
    private List<CommittedChangeList> mergeLocationGroupChangeLists(@NotNull RepositoryLocationGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "mergeLocationGroupChangeLists"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        ArrayList equalLists = ContainerUtil.newArrayList();
        CommittedChangeList previousList = null;
        for (CommittedChangeList list2 : Iterables.mergeSorted(this.collectChangeLists(group.getLocations()), this.myComparator)) {
            if (previousList != null && this.myComparator.compare(previousList, list2) != 0) {
                result2.add(this.zip(group, equalLists));
                equalLists.clear();
            }
            equalLists.add(list2);
            previousList = list2;
        }
        if (!equalLists.isEmpty()) {
            result2.add(this.zip(group, equalLists));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "mergeLocationGroupChangeLists"));
        }
        return arrayList;
    }

    @NotNull
    private CommittedChangeList zip(@NotNull RepositoryLocationGroup group, @NotNull List<CommittedChangeList> equalLists) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "zip"));
        }
        if (equalLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalLists", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "zip"));
        }
        if (equalLists.isEmpty()) {
            throw new IllegalArgumentException("equalLists can not be empty");
        }
        CommittedChangeList committedChangeList = equalLists.size() > 1 ? this.myVcsPartner.zip(group, equalLists) : equalLists.get(0);
        if (committedChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper", "zip"));
        }
        return committedChangeList;
    }
}

