/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CompositeRepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeCommittedChangesProvider
implements CommittedChangesProvider<CommittedChangeList, CompositeChangeBrowserSettings> {
    private final Project myProject;
    private List<AbstractVcs> myBaseVcss = new ArrayList<AbstractVcs>();

    public CompositeCommittedChangesProvider(Project project2, AbstractVcs ... baseVcss) {
        this.myProject = project2;
        this.myBaseVcss = new ArrayList<AbstractVcs>();
        Collections.addAll(this.myBaseVcss, baseVcss);
    }

    @NotNull
    public CompositeChangeBrowserSettings createDefaultSettings() {
        HashMap<AbstractVcs, ChangeBrowserSettings> map2 = new HashMap<AbstractVcs, ChangeBrowserSettings>();
        for (AbstractVcs vcs : this.myBaseVcss) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            assert (provider != null);
            map2.put(vcs, provider.createDefaultSettings());
        }
        CompositeChangeBrowserSettings compositeChangeBrowserSettings = new CompositeChangeBrowserSettings(map2);
        if (compositeChangeBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CompositeCommittedChangesProvider", "createDefaultSettings"));
        }
        return compositeChangeBrowserSettings;
    }

    public ChangesBrowserSettingsEditor<CompositeChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new CompositeChangesBrowserSettingsEditor();
    }

    public CompositeRepositoryLocation getLocationFor(FilePath root) {
        CommittedChangesProvider committedChangesProvider;
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root);
        if (vcs != null && (committedChangesProvider = vcs.getCommittedChangesProvider()) != null) {
            return new CompositeRepositoryLocation(committedChangesProvider, CommittedChangesCache.getInstance(this.myProject).getLocationCache().getLocation(vcs, root, false));
        }
        return null;
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        throw new UnsupportedOperationException();
    }

    public List<CommittedChangeList> getCommittedChanges(CompositeChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        throw new UnsupportedOperationException();
    }

    public void loadCommittedChanges(CompositeChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer2) throws VcsException {
        throw new UnsupportedOperationException();
    }

    public ChangeListColumn[] getColumns() {
        LinkedHashSet<ChangeListColumn> columns = new LinkedHashSet<ChangeListColumn>();
        for (AbstractVcs vcs : this.myBaseVcss) {
            ChangeListColumn[] providerColumns;
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            assert (provider != null);
            for (ChangeListColumn col : providerColumns = provider.getColumns()) {
                if (col != ChangeListColumn.DATE && col != ChangeListColumn.DESCRIPTION && col != ChangeListColumn.NAME && !(col instanceof ChangeListColumn.ChangeListNumberColumn)) continue;
                columns.add(col);
            }
        }
        return columns.toArray(new ChangeListColumn[columns.size()]);
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        JBTabbedPane tabbedPane = null;
        ArrayList actions2 = null;
        ArrayList toolbarActions2 = null;
        final ArrayList<Runnable> calledOnDispose = new ArrayList<Runnable>();
        for (AbstractVcs baseVcs : this.myBaseVcss) {
            VcsCommittedViewAuxiliary auxiliary;
            CommittedChangesProvider provider = baseVcs.getCommittedChangesProvider();
            if (provider == null || (auxiliary = provider.createActions(manager, location)) == null) continue;
            if (tabbedPane == null) {
                tabbedPane = new JBTabbedPane();
                actions2 = new ArrayList();
                toolbarActions2 = new ArrayList();
            }
            actions2.addAll(auxiliary.getPopupActions());
            toolbarActions2.addAll(auxiliary.getToolbarActions());
            calledOnDispose.add(auxiliary.getCalledOnViewDispose());
        }
        if (tabbedPane != null) {
            JPanel panel2 = new JPanel();
            panel2.add((Component)tabbedPane);
            return new VcsCommittedViewAuxiliary(actions2, new Runnable(){

                @Override
                public void run() {
                    for (Runnable runnable2 : calledOnDispose) {
                        runnable2.run();
                    }
                }
            }, toolbarActions2);
        }
        return null;
    }

    public int getUnlimitedCountValue() {
        throw new UnsupportedOperationException();
    }

    public Pair<CommittedChangeList, FilePath> getOneList(VirtualFile file2, VcsRevisionNumber number) {
        throw new UnsupportedOperationException();
    }

    public RepositoryLocation getForNonLocal(VirtualFile file2) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    private class CompositeChangesBrowserSettingsEditor
    implements ChangesBrowserSettingsEditor<CompositeChangeBrowserSettings> {
        private final JPanel myCompositePanel;
        private final DateFilterComponent myDateFilter;
        private CompositeChangeBrowserSettings mySettings;
        private final Map<AbstractVcs, ChangesBrowserSettingsEditor> myEditors = new HashMap<AbstractVcs, ChangesBrowserSettingsEditor>();
        private final Map<AbstractVcs, JCheckBox> myEnabledCheckboxes = new HashMap<AbstractVcs, JCheckBox>();

        public CompositeChangesBrowserSettingsEditor() {
            this.myCompositePanel = new JPanel();
            this.myCompositePanel.setLayout(new BoxLayout(this.myCompositePanel, 1));
            this.myDateFilter = new DateFilterComponent();
            this.myCompositePanel.add(this.myDateFilter.getPanel());
            for (AbstractVcs vcs : CompositeCommittedChangesProvider.this.myBaseVcss) {
                CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                assert (provider != null);
                final ChangesBrowserSettingsEditor editor = provider.createFilterUI(false);
                this.myEditors.put(vcs, editor);
                JPanel wrapperPane = new JPanel(new BorderLayout());
                wrapperPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)vcs.getDisplayName(), (boolean)true));
                final JCheckBox checkBox2 = new JCheckBox(VcsBundle.message((String)"composite.change.provider.include.vcs.checkbox", (Object[])new Object[]{vcs.getDisplayName()}), true);
                checkBox2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        CompositeChangesBrowserSettingsEditor.this.updateVcsEnabled(checkBox2, editor);
                    }
                });
                wrapperPane.add((Component)checkBox2, "North");
                this.myEnabledCheckboxes.put(vcs, checkBox2);
                wrapperPane.add((Component)editor.getComponent(), "Center");
                this.myCompositePanel.add(wrapperPane);
            }
        }

        private void updateVcsEnabled(JCheckBox checkBox2, ChangesBrowserSettingsEditor editor) {
            UIUtil.setEnabled((Component)editor.getComponent(), (boolean)checkBox2.isSelected(), (boolean)true);
            if (checkBox2.isSelected()) {
                editor.updateEnabledControls();
            }
        }

        public JComponent getComponent() {
            return this.myCompositePanel;
        }

        public CompositeChangeBrowserSettings getSettings() {
            HashSet<AbstractVcs> enabledVcss = new HashSet<AbstractVcs>();
            for (AbstractVcs vcs : this.myEditors.keySet()) {
                ChangeBrowserSettings settings = this.myEditors.get(vcs).getSettings();
                this.myDateFilter.saveValues(settings);
                this.mySettings.put(vcs, settings);
                if (!this.myEnabledCheckboxes.get(vcs).isSelected()) continue;
                enabledVcss.add(vcs);
            }
            this.mySettings.setEnabledVcss(enabledVcss);
            return this.mySettings;
        }

        public void setSettings(CompositeChangeBrowserSettings settings) {
            this.mySettings = settings;
            boolean dateFilterInitialized = false;
            for (AbstractVcs vcs : this.myEditors.keySet()) {
                ChangeBrowserSettings vcsSettings = this.mySettings.get(vcs);
                ChangesBrowserSettingsEditor editor = this.myEditors.get(vcs);
                editor.setSettings(vcsSettings);
                if (!dateFilterInitialized) {
                    this.myDateFilter.initValues(vcsSettings);
                    dateFilterInitialized = true;
                }
                JCheckBox checkBox2 = this.myEnabledCheckboxes.get(vcs);
                checkBox2.setSelected(settings.getEnabledVcss().contains(vcs));
                this.updateVcsEnabled(checkBox2, editor);
            }
        }

        @Nullable
        public String validateInput() {
            for (ChangesBrowserSettingsEditor editor : this.myEditors.values()) {
                String result2 = editor.validateInput();
                if (result2 == null) continue;
                return result2;
            }
            return null;
        }

        public void updateEnabledControls() {
            for (ChangesBrowserSettingsEditor editor : this.myEditors.values()) {
                editor.updateEnabledControls();
            }
        }

        public String getDimensionServiceKey() {
            StringBuilder result2 = new StringBuilder();
            result2.append("Composite");
            for (AbstractVcs vcs : CompositeCommittedChangesProvider.this.myBaseVcss) {
                result2.append(".").append(vcs.getDisplayName());
            }
            return result2.toString();
        }
    }

    public static class CompositeChangeBrowserSettings
    extends ChangeBrowserSettings {
        private final Map<AbstractVcs, ChangeBrowserSettings> myMap;
        private final Set<AbstractVcs> myEnabledVcs = new HashSet<AbstractVcs>();

        public CompositeChangeBrowserSettings(Map<AbstractVcs, ChangeBrowserSettings> map2) {
            this.myMap = map2;
            this.myEnabledVcs.addAll(map2.keySet());
        }

        public void put(AbstractVcs vcs, ChangeBrowserSettings settings) {
            this.myMap.put(vcs, settings);
        }

        public ChangeBrowserSettings get(AbstractVcs vcs) {
            return this.myMap.get(vcs);
        }

        public void setEnabledVcss(Collection<AbstractVcs> vcss) {
            this.myEnabledVcs.clear();
            this.myEnabledVcs.addAll(vcss);
        }

        public Collection<AbstractVcs> getEnabledVcss() {
            return this.myEnabledVcs;
        }
    }
}

