/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GetCommittedChangelistAction
extends AbstractCommonUpdateAction {
    private static final ScopeInfo CHANGELIST = new ScopeInfo(){

        @Override
        public FilePath[] getRoots(VcsContext context2, ActionInfo actionInfo) {
            Collection filePaths = GetCommittedChangelistAction.getFilePaths(context2);
            return filePaths.toArray(new FilePath[filePaths.size()]);
        }

        @Override
        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            return "Changelist";
        }

        @Override
        public boolean filterExistsInVcs() {
            return false;
        }
    };

    public GetCommittedChangelistAction() {
        super(ActionInfo.UPDATE, CHANGELIST, false);
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context2) {
        int rc;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/committed/GetCommittedChangelistAction", "actionPerformed"));
        }
        Collection<FilePath> filePaths = GetCommittedChangelistAction.getFilePaths(context2);
        ArrayList selectedChangeLists = new ArrayList();
        ChangeList[] selectionFromContext = context2.getSelectedChangeLists();
        if (selectionFromContext != null) {
            Collections.addAll(selectedChangeLists, selectionFromContext);
        }
        List<CommittedChangeList> incomingChanges = CommittedChangesCache.getInstance(context2.getProject()).getCachedIncomingChanges();
        ArrayList<CommittedChangeList> intersectingChanges = new ArrayList<CommittedChangeList>();
        if (incomingChanges != null) {
            block0: for (CommittedChangeList changeList : incomingChanges) {
                if (selectedChangeLists.contains(changeList)) continue;
                for (Change change : changeList.getChanges()) {
                    if (!filePaths.contains(ChangesUtil.getFilePath((Change)change))) continue;
                    intersectingChanges.add(changeList);
                    continue block0;
                }
            }
        }
        if (intersectingChanges.size() > 0 && (rc = Messages.showOkCancelDialog((Project)context2.getProject(), (String)VcsBundle.message((String)"get.committed.changes.intersecting.prompt", (Object[])new Object[]{intersectingChanges.size(), selectedChangeLists.size()}), (String)VcsBundle.message((String)"get.committed.changes.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        super.actionPerformed(context2);
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return false;
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/changes/committed/GetCommittedChangelistAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/changes/committed/GetCommittedChangelistAction", "update"));
        }
        super.update(vcsContext, presentation);
        ChangeList[] changeLists = vcsContext.getSelectedChangeLists();
        presentation.setEnabled(presentation.isEnabled() && CommittedChangesCache.getInstance(vcsContext.getProject()).getCachedIncomingChanges() != null && changeLists != null && changeLists.length > 0);
    }

    private static Collection<FilePath> getFilePaths(VcsContext context2) {
        HashSet<FilePath> files2 = new HashSet<FilePath>();
        ChangeList[] selectedChangeLists = context2.getSelectedChangeLists();
        if (selectedChangeLists != null) {
            for (ChangeList changelist : selectedChangeLists) {
                for (Change change : changelist.getChanges()) {
                    files2.add(ChangesUtil.getFilePath((Change)change));
                }
            }
        }
        return files2;
    }
}

