/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ReceivedChangeList
extends CommittedChangeListImpl {
    @NotNull
    private final CommittedChangeList myBaseList;
    private final int myBaseCount;
    private boolean myForcePartial;

    public ReceivedChangeList(@NotNull CommittedChangeList baseList) {
        if (baseList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseList", "com/intellij/openapi/vcs/changes/committed/ReceivedChangeList", "<init>"));
        }
        super(baseList.getName(), baseList.getComment(), baseList.getCommitterName(), baseList.getNumber(), baseList.getCommitDate(), Collections.emptyList());
        this.myBaseList = baseList;
        this.myBaseCount = baseList.getChanges().size();
        this.myForcePartial = false;
    }

    public void addChange(Change change) {
        this.myChanges.add(change);
    }

    public boolean isPartial() {
        return this.myForcePartial || this.myChanges.size() < this.myBaseCount;
    }

    public void setForcePartial(boolean forcePartial) {
        this.myForcePartial = forcePartial;
    }

    public AbstractVcs getVcs() {
        return this.myBaseList.getVcs();
    }

    @NotNull
    public CommittedChangeList getBaseList() {
        CommittedChangeList committedChangeList = this.myBaseList;
        if (committedChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/ReceivedChangeList", "getBaseList"));
        }
        return committedChangeList;
    }

    public void setDescription(String newMessage) {
        this.myBaseList.setDescription(newMessage);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        ReceivedChangeList that = (ReceivedChangeList)((Object)o2);
        return this.myBaseList.equals(that.myBaseList);
    }

    public int hashCode() {
        return this.myBaseList.hashCode();
    }

    static CommittedChangeList unwrap(CommittedChangeList changeList) {
        if (changeList instanceof ReceivedChangeList) {
            changeList = ((ReceivedChangeList)changeList).getBaseList();
        }
        return changeList;
    }

    public String toString() {
        return this.myBaseList.toString();
    }
}

