/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.committed.CacheSettingsDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.util.Consumer;

public class RefreshIncomingChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            RefreshIncomingChangesAction.doRefresh(project2);
        }
    }

    public static void doRefresh(final Project project2) {
        final CommittedChangesCache cache = CommittedChangesCache.getInstance(project2);
        cache.hasCachesForAnyRoot(new Consumer<Boolean>(){

            public void consume(Boolean notEmpty) {
                if (!notEmpty.booleanValue() && !CacheSettingsDialog.showSettingsDialog(project2)) {
                    return;
                }
                cache.refreshAllCachesAsync(true, false);
                cache.refreshIncomingChangesAsync();
            }
        });
    }

    public void update(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        e2.getPresentation().setEnabled(project2 != null && !CommittedChangesCache.getInstance(project2).isRefreshingIncomingChanges());
    }
}

