/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.OpenRepositoryVersionAction;
import com.intellij.openapi.vcs.changes.actions.RevertSelectedChangesAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffWithLocalAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class RepositoryChangesBrowser
extends ChangesBrowser
implements DataProvider {
    private CommittedChangesBrowserUseCase myUseCase;
    private EditSourceAction myEditSourceAction;

    public RepositoryChangesBrowser(Project project2, List<CommittedChangeList> changeLists) {
        this(project2, changeLists, Collections.emptyList(), null);
    }

    public RepositoryChangesBrowser(Project project2, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        this(project2, changeLists, changes, initialListSelection, null);
    }

    public RepositoryChangesBrowser(Project project2, List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection, VirtualFile toSelect) {
        super(project2, changeLists, changes, initialListSelection, false, false, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, toSelect);
    }

    @Override
    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        AnAction[] actions2;
        super.buildToolBar(toolBarGroup);
        toolBarGroup.add((AnAction)new ShowDiffWithLocalAction());
        this.myEditSourceAction = new MyEditSourceAction();
        this.myEditSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        toolBarGroup.add((AnAction)this.myEditSourceAction);
        OpenRepositoryVersionAction action2 = new OpenRepositoryVersionAction();
        toolBarGroup.add((AnAction)action2);
        RevertSelectedChangesAction revertSelectedChangesAction = new RevertSelectedChangesAction();
        toolBarGroup.add((AnAction)revertSelectedChangesAction);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("RepositoryChangesBrowserToolbar");
        for (AnAction anAction : actions2 = group.getChildren(null)) {
            toolBarGroup.add(anAction);
        }
    }

    public void setUseCase(CommittedChangesBrowserUseCase useCase) {
        this.myUseCase = useCase;
    }

    public Object getData(@NonNls String dataId) {
        if (CommittedChangesBrowserUseCase.DATA_KEY.is(dataId)) {
            return this.myUseCase;
        }
        if (VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            List<Change> list2 = this.myViewer.getSelectedChanges();
            return list2.toArray(new Change[list2.size()]);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            Change[] changeArray;
            Change highestSelection = (Change)this.myViewer.getHighestLeadSelection();
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            return changeArray;
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            Set abstractVcs = ChangesUtil.getAffectedVcses(this.myViewer.getSelectedChanges(), (Project)this.myProject);
            if (abstractVcs.size() == 1) {
                return ((AbstractVcs)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)abstractVcs))).getKeyInstanceMethod();
            }
            return null;
        }
        TypeSafeDataProviderAdapter adapter2 = new TypeSafeDataProviderAdapter(this);
        return adapter2.getData(dataId);
    }

    public EditSourceAction getEditSourceAction() {
        return this.myEditSourceAction;
    }

    private class MyEditSourceAction
    extends EditSourceAction {
        private final Icon myEditSourceIcon = AllIcons.Actions.EditSource;

        @Override
        public void update(AnActionEvent event) {
            super.update(event);
            event.getPresentation().setIcon(this.myEditSourceIcon);
            event.getPresentation().setText("Edit Source");
            if (!ModalityState.NON_MODAL.equals(ModalityState.current()) || CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(event.getDataContext()))) {
                event.getPresentation().setEnabled(false);
            } else {
                event.getPresentation().setEnabled(true);
            }
        }

        @Override
        protected Navigatable[] getNavigatables(DataContext dataContext) {
            Change[] changes = (Change[])VcsDataKeys.SELECTED_CHANGES.getData(dataContext);
            return changes != null ? ChangesUtil.getNavigatableArray((Project)RepositoryChangesBrowser.this.myProject, (Stream)ChangesUtil.getAllFiles(Stream.of(changes))) : null;
        }
    }
}

