/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;
    private final ChangeListManagerImpl myManager;

    public ChangelistConflictAccessProvider(Project project2, ChangeListManagerImpl manager) {
        this.myProject = project2;
        this.myManager = manager;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files2) {
        ChangelistConflictTracker.Options options = this.myManager.getConflictTracker().getOptions();
        if (!options.TRACKING_ENABLED || !options.SHOW_DIALOG) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "requestWriting"));
            }
            return list2;
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files2) {
            if (file2 == null || this.myManager.getConflictTracker().isWritingAllowed(file2)) continue;
            denied.add(file2);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog2;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> changes = new ArrayList<Change>();
            for (VirtualFile file2 : denied) {
                changeLists.add(this.myManager.getChangeList(file2));
                changes.add(this.myManager.getChange(file2));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog2 = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog2.show();
            } while (dialog2.isOK() && !dialog2.getResolution().resolveConflict(this.myProject, changes, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog2.isOK()) {
                options.LAST_RESOLUTION = dialog2.getResolution();
                List<VirtualFile> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "requestWriting"));
                }
                return list3;
            }
        }
        ArrayList<VirtualFile> arrayList = denied;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "requestWriting"));
        }
        return arrayList;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "isPotentiallyWritable"));
        }
        return true;
    }
}

