/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InplaceButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class ChangelistConflictNotificationPanel
extends EditorNotificationPanel {
    private final ChangeList myChangeList;
    private final VirtualFile myFile;
    private final ChangelistConflictTracker myTracker;

    @Nullable
    public static ChangelistConflictNotificationPanel create(ChangelistConflictTracker tracker, VirtualFile file2) {
        ChangeListManager manager = tracker.getChangeListManager();
        Change change = manager.getChange(file2);
        if (change == null) {
            return null;
        }
        LocalChangeList changeList = manager.getChangeList(change);
        if (changeList == null) {
            return null;
        }
        return new ChangelistConflictNotificationPanel(tracker, file2, changeList);
    }

    private ChangelistConflictNotificationPanel(ChangelistConflictTracker tracker, VirtualFile file2, LocalChangeList changeList) {
        this.myTracker = tracker;
        this.myFile = file2;
        final ChangeListManager manager = tracker.getChangeListManager();
        this.myChangeList = changeList;
        this.myLabel.setText("File from non-active changelist is modified");
        this.createActionLabel("Move changes", () -> ChangelistConflictResolution.MOVE.resolveConflict(this.myTracker.getProject(), this.myChangeList.getChanges(), this.myFile)).setToolTipText("Move changes to active changelist (" + manager.getDefaultChangeList().getName() + ")");
        this.createActionLabel("Switch changelist", () -> {
            Change change = this.myTracker.getChangeListManager().getChange(this.myFile);
            if (change == null) {
                Messages.showInfoMessage((String)"No changes for this file", (String)"Message");
            } else {
                ChangelistConflictResolution.SWITCH.resolveConflict(this.myTracker.getProject(), Collections.singletonList(change), null);
            }
        }).setToolTipText("Set active changelist to '" + this.myChangeList.getName() + "'");
        this.createActionLabel("Ignore", () -> this.myTracker.ignoreConflict(this.myFile, true)).setToolTipText("Hide this notification");
        this.myLinksPanel.add((Component)new InplaceButton("Show options dialog", AllIcons.General.Settings, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ShowSettingsUtil.getInstance().editConfigurable(ChangelistConflictNotificationPanel.this.myTracker.getProject(), (Configurable)new ChangelistConflictConfigurable((ChangeListManagerImpl)manager));
            }
        }));
    }
}

