/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Font;
import java.util.List;

public class IssueLinkHtmlRenderer {
    private IssueLinkHtmlRenderer() {
    }

    public static String formatTextIntoHtml(Project project2, String c2) {
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + IssueLinkHtmlRenderer.formatTextWithLinks(project2, c2) + "</body></html>";
    }

    public static String formatTextWithLinks(Project project2, String str, Convertor<String, String> convertor) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        String comment = XmlStringUtil.escapeString((String)str, (boolean)false);
        StringBuilder commentBuilder = new StringBuilder();
        IssueNavigationConfiguration config = IssueNavigationConfiguration.getInstance((Project)project2);
        List list2 = config.findIssueLinks((CharSequence)comment);
        int pos = 0;
        for (IssueNavigationConfiguration.LinkMatch match : list2) {
            TextRange range = match.getRange();
            commentBuilder.append((String)convertor.convert((Object)comment.substring(pos, range.getStartOffset()))).append("<a href=\"").append(match.getTargetUrl()).append("\">");
            commentBuilder.append(range.substring(comment)).append("</a>");
            pos = range.getEndOffset();
        }
        commentBuilder.append((String)convertor.convert((Object)comment.substring(pos)));
        comment = commentBuilder.toString();
        return comment.replace("\n", "<br>");
    }

    public static String formatTextWithLinks(Project project2, String c2) {
        return IssueLinkHtmlRenderer.formatTextWithLinks(project2, c2, (Convertor<String, String>)Convertor.SELF);
    }
}

