/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.vcs.changes.issueLinks.AbstractBaseTagMouseListener;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.TreeTableView;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableLinkMouseListener
extends AbstractBaseTagMouseListener {
    @Nullable
    public Object getTagAt(@NotNull MouseEvent e2) {
        Object tag;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/issueLinks/TableLinkMouseListener", "getTagAt"));
        }
        JTable table2 = (JTable)e2.getSource();
        int row = table2.rowAtPoint(e2.getPoint());
        int column = table2.columnAtPoint(e2.getPoint());
        if (row == -1 || column == -1) {
            return null;
        }
        TableCellRenderer cellRenderer = table2.getCellRenderer(row, column);
        if (cellRenderer instanceof DualView.TableCellRendererWrapper) {
            cellRenderer = ((DualView.TableCellRendererWrapper)cellRenderer).getRenderer();
        }
        if (cellRenderer instanceof TreeTableView.CellRendererWrapper) {
            cellRenderer = ((TreeTableView.CellRendererWrapper)cellRenderer).getBaseRenderer();
        }
        if (cellRenderer instanceof ColoredTableCellRenderer) {
            ColoredTableCellRenderer renderer = (ColoredTableCellRenderer)cellRenderer;
            tag = TableLinkMouseListener.forColoredRenderer(e2, table2, row, column, renderer);
        } else {
            tag = this.tryGetTag(e2, table2, row, column);
        }
        return tag;
    }

    protected Object tryGetTag(MouseEvent e2, JTable table2, int row, int column) {
        return null;
    }

    private static Object forColoredRenderer(MouseEvent e2, JTable table2, int row, int column, ColoredTableCellRenderer renderer) {
        renderer.getTableCellRendererComponent(table2, table2.getValueAt(row, column), false, false, row, column);
        Rectangle rc = table2.getCellRect(row, column, false);
        return renderer.getFragmentTagAt(e2.getX() - rc.x);
    }
}

