/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.vcs.changes.issueLinks.ClickableTreeCellRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeNodePartListener
extends LinkMouseListenerBase {
    private final ClickableTreeCellRenderer myRenderer;
    private DefaultMutableTreeNode myLastHitNode;
    private Component myRenderedComp;

    public TreeNodePartListener(ClickableTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    protected Object getTagAt(@NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/issueLinks/TreeNodePartListener", "getTagAt"));
        }
        JTree tree2 = (JTree)e2.getSource();
        TreePath path = tree2.getPathForLocation(e2.getX(), e2.getY());
        if (path != null) {
            Rectangle bounds;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.myLastHitNode != treeNode) {
                this.myLastHitNode = treeNode;
                this.myRenderedComp = this.myRenderer.getTreeCellRendererComponent(tree2, treeNode, false, false, treeNode.isLeaf(), -1, false);
            }
            if (this.myRenderedComp != null && (bounds = tree2.getPathBounds(path)) != null) {
                Component root = tree2.getCellRenderer().getTreeCellRendererComponent(tree2, treeNode, false, false, treeNode.isLeaf(), -1, false);
                root.setSize(bounds.getSize());
                root.doLayout();
                int compX = this.myRenderedComp.getX() + bounds.x;
                int compY = this.myRenderedComp.getY() + bounds.y;
                if (compX < e2.getX() && compX + this.myRenderedComp.getWidth() > e2.getX() && compY < e2.getY() && compY + this.myRenderedComp.getHeight() > e2.getY()) {
                    return this.myRenderer.getTag();
                }
            }
        }
        return null;
    }
}

