/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.util.LineRange;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AppliedTextPatch {
    @NotNull
    private final List<AppliedSplitPatchHunk> mySplitPatchHunkList;

    public static AppliedTextPatch create(@NotNull List<AppliedSplitPatchHunk> splitPatchHunkList) {
        if (splitPatchHunkList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitPatchHunkList", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch", "create"));
        }
        ArrayList<AppliedSplitPatchHunk> hunks = new ArrayList<AppliedSplitPatchHunk>(splitPatchHunkList);
        BitSet appliedLines = new BitSet();
        for (int i2 = 0; i2 < hunks.size(); ++i2) {
            AppliedSplitPatchHunk hunk = (AppliedSplitPatchHunk)hunks.get(i2);
            LineRange appliedTo = hunk.getAppliedTo();
            if (appliedTo == null) continue;
            int nextAppliedLine = appliedLines.nextSetBit(appliedTo.start);
            if (nextAppliedLine != -1 && nextAppliedLine < appliedTo.end) {
                hunks.set(i2, new AppliedSplitPatchHunk(hunk, -1, -1, HunkStatus.NOT_APPLIED));
                continue;
            }
            appliedLines.set(appliedTo.start, appliedTo.end, true);
        }
        ContainerUtil.sort(hunks, Comparator.comparingInt(o2 -> o2.getLineRangeBefore().start));
        return new AppliedTextPatch(hunks);
    }

    private AppliedTextPatch(@NotNull List<AppliedSplitPatchHunk> hunks) {
        if (hunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hunks", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch", "<init>"));
        }
        this.mySplitPatchHunkList = hunks;
    }

    @NotNull
    public List<AppliedSplitPatchHunk> getHunks() {
        List<AppliedSplitPatchHunk> list2 = this.mySplitPatchHunkList;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch", "getHunks"));
        }
        return list2;
    }

    public static class AppliedSplitPatchHunk {
        @NotNull
        private final HunkStatus myStatus;
        @NotNull
        private final List<String> myContextBefore;
        @NotNull
        private final List<String> myContextAfter;
        @NotNull
        private final List<String> myDeletedLines;
        @NotNull
        private final List<String> myInsertedLines;
        private final int myAppliedToLinesStart;
        private final int myAppliedToLinesEnd;
        private final int myStartLineBefore;
        private final int myStartLineAfter;

        public AppliedSplitPatchHunk(@NotNull GenericPatchApplier.SplitHunk splitHunk, int startLineApplied, int endLineApplied, @NotNull HunkStatus status) {
            if (splitHunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitHunk", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "<init>"));
            }
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "<init>"));
            }
            this.myStatus = status;
            this.myAppliedToLinesStart = startLineApplied;
            this.myAppliedToLinesEnd = endLineApplied;
            this.myStartLineBefore = splitHunk.getStartLineBefore();
            this.myStartLineAfter = splitHunk.getStartLineAfter();
            this.myContextBefore = splitHunk.getContextBefore();
            this.myContextAfter = splitHunk.getContextAfter();
            this.myDeletedLines = new ArrayList<String>();
            this.myInsertedLines = new ArrayList<String>();
            for (BeforeAfter<List<String>> step : splitHunk.getPatchSteps()) {
                this.myDeletedLines.addAll((Collection)step.getBefore());
                this.myInsertedLines.addAll((Collection)step.getAfter());
            }
        }

        private AppliedSplitPatchHunk(@NotNull AppliedSplitPatchHunk hunk, int appliedToLinesStart, int appliedToLinesEnd, @NotNull HunkStatus status) {
            if (hunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hunk", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "<init>"));
            }
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "<init>"));
            }
            this.myStatus = status;
            this.myAppliedToLinesStart = appliedToLinesStart;
            this.myAppliedToLinesEnd = appliedToLinesEnd;
            this.myContextBefore = hunk.myContextBefore;
            this.myContextAfter = hunk.myContextAfter;
            this.myDeletedLines = hunk.myDeletedLines;
            this.myInsertedLines = hunk.myInsertedLines;
            this.myStartLineBefore = hunk.myStartLineBefore;
            this.myStartLineAfter = hunk.myStartLineAfter;
        }

        public LineRange getAppliedTo() {
            if (this.myStatus == HunkStatus.NOT_APPLIED) {
                return null;
            }
            return new LineRange(this.myAppliedToLinesStart, this.myAppliedToLinesEnd);
        }

        @NotNull
        public LineRange getLineRangeBefore() {
            int start2 = this.myStartLineBefore;
            LineRange lineRange = new LineRange(start2, start2 + this.myContextBefore.size() + this.myDeletedLines.size() + this.myContextAfter.size());
            if (lineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getLineRangeBefore"));
            }
            return lineRange;
        }

        @NotNull
        public LineRange getLineRangeAfter() {
            int start2 = this.myStartLineAfter;
            LineRange lineRange = new LineRange(start2, start2 + this.myContextBefore.size() + this.myInsertedLines.size() + this.myContextAfter.size());
            if (lineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getLineRangeAfter"));
            }
            return lineRange;
        }

        @NotNull
        public HunkStatus getStatus() {
            HunkStatus hunkStatus = this.myStatus;
            if (hunkStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getStatus"));
            }
            return hunkStatus;
        }

        @NotNull
        public List<String> getContextBefore() {
            List<String> list2 = this.myContextBefore;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getContextBefore"));
            }
            return list2;
        }

        @NotNull
        public List<String> getContextAfter() {
            List<String> list2 = this.myContextAfter;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getContextAfter"));
            }
            return list2;
        }

        @NotNull
        public List<String> getDeletedLines() {
            List<String> list2 = this.myDeletedLines;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getDeletedLines"));
            }
            return list2;
        }

        @NotNull
        public List<String> getInsertedLines() {
            List<String> list2 = this.myInsertedLines;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk", "getInsertedLines"));
            }
            return list2;
        }
    }

    public static enum HunkStatus {
        ALREADY_APPLIED,
        EXACTLY_APPLIED,
        NOT_APPLIED;

    }
}

