/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.patch.CommonBinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.SimpleBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryFilePatchInProgress
extends CommonBinaryFilePatchInProgress<BinaryFilePatch> {
    protected BinaryFilePatchInProgress(@NotNull BinaryFilePatch patch, @Nullable Collection<VirtualFile> autoBases, @NotNull VirtualFile baseDir) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/BinaryFilePatchInProgress", "<init>"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/vcs/changes/patch/BinaryFilePatchInProgress", "<init>"));
        }
        super(patch.copy(), autoBases, baseDir);
    }

    @Override
    @NotNull
    protected BinaryContentRevision createNewContentRevision(@NotNull FilePath newFilePath) {
        if (newFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFilePath", "com/intellij/openapi/vcs/changes/patch/BinaryFilePatchInProgress", "createNewContentRevision"));
        }
        SimpleBinaryContentRevision simpleBinaryContentRevision = new SimpleBinaryContentRevision(newFilePath){

            @Nullable
            public byte[] getBinaryContent() throws VcsException {
                return ((BinaryFilePatch)BinaryFilePatchInProgress.this.myPatch).getAfterContent();
            }
        };
        if (simpleBinaryContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BinaryFilePatchInProgress", "createNewContentRevision"));
        }
        return simpleBinaryContentRevision;
    }

    @Override
    @NotNull
    protected Change createChange(Project project2) {
        CurrentBinaryContentRevision before = null;
        BinaryContentRevision after2 = null;
        if (!((BinaryFilePatch)this.myPatch).isNewFile()) {
            before = new CurrentBinaryContentRevision(this.getFilePath()){

                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                    if (textRevisionNumber == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BinaryFilePatchInProgress$2", "getRevisionNumber"));
                    }
                    return textRevisionNumber;
                }
            };
        }
        if (!((BinaryFilePatch)this.myPatch).isDeletedFile()) {
            after2 = this.createNewContentRevision(this.getFilePath());
        }
        Change change = new Change((ContentRevision)before, (ContentRevision)after2);
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BinaryFilePatchInProgress", "createChange"));
        }
        return change;
    }
}

