/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BinaryEncoder;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryPatchWriter {
    private static final Logger LOG = Logger.getInstance(BinaryFilePatch.class);
    private static final String GIT_DIFF_HEADER = "diff --git %s %s";
    private static final String FILE_MODE_HEADER = "%s file mode %d";
    private static final String INDEX_SHA1_HEADER = "index %s..%s";
    private static final String GIT_BINARY_HEADER = "GIT binary patch";
    private static final String LITERAL_HEADER = "literal %d";
    private static final int REGULAR_FILE_MODE = 100644;
    private static final int EXECUTABLE_FILE_MODE = 100755;
    private static final int SYMBOLIC_LINK_MODE = 120000;

    public static void writeBinaries(@Nullable String basePath, @NotNull List<BinaryFilePatch> patches, @NotNull Writer writer) throws IOException {
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "writeBinaries"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "writeBinaries"));
        }
        String lineSeparator = "\n";
        for (FilePatch filePatch : patches) {
            BinaryFilePatch filePatch2 = (BinaryFilePatch)filePatch;
            writer.write(String.format(GIT_DIFF_HEADER, filePatch2.getBeforeName(), filePatch2.getAfterName()));
            writer.write(lineSeparator);
            File afterFile = new File(basePath, filePatch2.getAfterName());
            if (filePatch2.isDeletedFile()) {
                writer.write(BinaryPatchWriter.getFileModeHeader(FileStatus.DELETED, 100644));
                writer.write(lineSeparator);
            } else if (filePatch2.isNewFile()) {
                writer.write(BinaryPatchWriter.getFileModeHeader(FileStatus.ADDED, !SystemInfo.isWindows && afterFile.canExecute() ? 100755 : 100644));
                writer.write(lineSeparator);
            }
            byte[] afterContent = filePatch2.getAfterContent();
            writer.write(BinaryPatchWriter.getIndexHeader(filePatch2.isNewFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(filePatch2.getBeforeContent()), filePatch2.isDeletedFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(afterContent)));
            writer.write(lineSeparator);
            writer.write(GIT_BINARY_HEADER);
            writer.write(lineSeparator);
            writer.write(String.format(LITERAL_HEADER, afterContent == null ? 0 : afterContent.length));
            writer.write(lineSeparator);
            try {
                BinaryEncoder.encode((InputStream)(afterFile.exists() ? new FileInputStream(afterFile) : new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY)), (Writer)writer);
            }
            catch (BinaryEncoder.BinaryPatchException e2) {
                LOG.error("Can't write patch for binary file: " + afterFile.getPath(), (Throwable)e2);
            }
            writer.write(lineSeparator);
        }
    }

    @NotNull
    private static String getFileModeHeader(@NotNull FileStatus fileStatus, int mode) {
        if (fileStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatus", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "getFileModeHeader"));
        }
        String string2 = String.format(FILE_MODE_HEADER, fileStatus == FileStatus.DELETED ? "deleted" : "new", mode);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "getFileModeHeader"));
        }
        return string2;
    }

    @NotNull
    private static String getIndexHeader(@NotNull String beforeHash, @NotNull String afterHash) {
        if (beforeHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeHash", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "getIndexHeader"));
        }
        if (afterHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterHash", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "getIndexHeader"));
        }
        String string2 = String.format(INDEX_SHA1_HEADER, beforeHash, afterHash);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "getIndexHeader"));
        }
        return string2;
    }

    @NotNull
    private static String getSha1ForContent(@Nullable byte[] content2) {
        String string2 = content2 != null ? BlobIndexUtil.getSha1(content2) : BlobIndexUtil.NOT_COMMITTED_HASH;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter", "getSha1ForContent"));
        }
        return string2;
    }
}

