/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.shelf.CleanUnshelvedFilterDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import org.jetbrains.annotations.NotNull;

public class CleanUnshelvedAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedAction", "update"));
        }
        super.update(e2);
        Project project2 = CleanUnshelvedAction.getEventProject((AnActionEvent)e2);
        Presentation presentation = e2.getPresentation();
        if (project2 == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(!ShelveChangesManager.getInstance(project2).getRecycledShelvedChangeLists().isEmpty());
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        CleanUnshelvedFilterDialog dialog2 = new CleanUnshelvedFilterDialog(project2);
        dialog2.show();
        if (dialog2.isOK()) {
            if (dialog2.isUnshelvedWithFilterSelected()) {
                ShelveChangesManager.getInstance(project2).cleanUnshelved(false, dialog2.getTimeLimitInMillis());
            } else if (dialog2.isAllUnshelvedSelected()) {
                ShelveChangesManager.getInstance(project2).clearRecycled();
            } else {
                ShelveChangesManager.getInstance(project2).cleanUnshelved(true, System.currentTimeMillis());
            }
        }
    }
}

