/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;

public class RenameShelvedChangeListAction
extends AnAction {
    public void actionPerformed(AnActionEvent e2) {
        final Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        List<ShelvedChangeList> changelists = ShelvedChangesViewManager.getShelvedLists(e2.getDataContext());
        final ShelvedChangeList changeList = (ShelvedChangeList)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(changelists));
        String newName = Messages.showInputDialog((Project)project2, (String)VcsBundle.message((String)"shelve.changes.rename.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.changes.rename.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)changeList.DESCRIPTION, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                if (inputString.length() == 0) {
                    return false;
                }
                List<ShelvedChangeList> list2 = ShelveChangesManager.getInstance(project2).getShelvedChangeLists();
                for (ShelvedChangeList oldList : list2) {
                    if (oldList == changeList || !oldList.DESCRIPTION.equals(inputString)) continue;
                    return false;
                }
                return true;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newName != null && !newName.equals(changeList.DESCRIPTION)) {
            ShelveChangesManager.getInstance(project2).renameChangeList(changeList, newName);
        }
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(RenameShelvedChangeListAction.getEventProject((AnActionEvent)e2) != null && ShelvedChangesViewManager.getShelvedLists(e2.getDataContext()).size() == 1);
    }
}

