/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryFile
implements JDOMExternalizable {
    public String BEFORE_PATH;
    public String AFTER_PATH;
    @Nullable
    public String SHELVED_PATH;

    public ShelvedBinaryFile() {
    }

    public ShelvedBinaryFile(String beforePath, String afterPath, @Nullable String shelvedPath) {
        assert (beforePath != null || afterPath != null);
        this.BEFORE_PATH = beforePath;
        this.AFTER_PATH = afterPath;
        this.SHELVED_PATH = shelvedPath;
        this.convertPathsToSystemIndependent();
    }

    @Nullable
    private static String convertToSystemIndependent(@Nullable String beforePath) {
        return beforePath != null ? FileUtil.toSystemIndependentName((String)beforePath) : null;
    }

    private void convertPathsToSystemIndependent() {
        this.BEFORE_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.BEFORE_PATH);
        this.AFTER_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.AFTER_PATH);
        this.SHELVED_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.SHELVED_PATH);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.convertPathsToSystemIndependent();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public FileStatus getFileStatus() {
        if (this.BEFORE_PATH == null) {
            return FileStatus.ADDED;
        }
        if (this.SHELVED_PATH == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public Change createChange(Project project2) {
        FilePath file2;
        CurrentBinaryContentRevision before = null;
        ShelvedBinaryContentRevision after2 = null;
        File baseDir = new File(project2.getBaseDir().getPath());
        if (this.BEFORE_PATH != null) {
            file2 = VcsUtil.getFilePath((File)new File(baseDir, this.BEFORE_PATH), (boolean)false);
            before = new CurrentBinaryContentRevision(file2){

                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                    if (textRevisionNumber == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile$1", "getRevisionNumber"));
                    }
                    return textRevisionNumber;
                }
            };
        }
        if (this.AFTER_PATH != null) {
            file2 = VcsUtil.getFilePath((File)new File(baseDir, this.AFTER_PATH), (boolean)false);
            after2 = new ShelvedBinaryContentRevision(file2, this.SHELVED_PATH);
        }
        return new Change(before, after2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ShelvedBinaryFile that = (ShelvedBinaryFile)o2;
        if (this.AFTER_PATH != null ? !this.AFTER_PATH.equals(that.AFTER_PATH) : that.AFTER_PATH != null) {
            return false;
        }
        if (this.BEFORE_PATH != null ? !this.BEFORE_PATH.equals(that.BEFORE_PATH) : that.BEFORE_PATH != null) {
            return false;
        }
        return !(this.SHELVED_PATH != null ? !this.SHELVED_PATH.equals(that.SHELVED_PATH) : that.SHELVED_PATH != null);
    }

    public int hashCode() {
        int result2 = this.BEFORE_PATH != null ? this.BEFORE_PATH.hashCode() : 0;
        result2 = 31 * result2 + (this.AFTER_PATH != null ? this.AFTER_PATH.hashCode() : 0);
        result2 = 31 * result2 + (this.SHELVED_PATH != null ? this.SHELVED_PATH.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.BEFORE_PATH == null ? this.AFTER_PATH : this.BEFORE_PATH));
    }
}

