/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import org.jetbrains.annotations.NotNull;

public class ShowHideRecycledAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/ShowHideRecycledAction", "update"));
        }
        super.update(e2);
        Project project2 = ShowHideRecycledAction.getEventProject((AnActionEvent)e2);
        Presentation presentation = e2.getPresentation();
        presentation.setEnabledAndVisible(project2 != null);
        if (project2 != null) {
            boolean fromContextMenu = "Vcs.Shelf.ContextMenu".equals(e2.getPlace());
            presentation.setText(ShelveChangesManager.getInstance(project2).isShowRecycled() && !fromContextMenu ? "Hide Already Unshelved" : "Show Already Unshelved");
            presentation.setIcon(fromContextMenu ? null : AllIcons.Nodes.DisabledPointcut);
        }
    }

    public boolean isSelected(AnActionEvent e2) {
        Project project2 = ShowHideRecycledAction.getEventProject((AnActionEvent)e2);
        return project2 != null && ShelveChangesManager.getInstance(project2).isShowRecycled();
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        Project project2 = ShowHideRecycledAction.getEventProject((AnActionEvent)e2);
        if (project2 != null) {
            ShelveChangesManager.getInstance(project2).setShowRecycled(state);
        }
    }
}

