/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleBinaryContentRevision
implements BinaryContentRevision {
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final String myRevisionPresentationName;

    public SimpleBinaryContentRevision(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/shelf/SimpleBinaryContentRevision", "<init>"));
        }
        this.myPath = path;
        this.myRevisionPresentationName = VcsBundle.message((String)"patched.version.name", (Object[])new Object[0]);
    }

    public SimpleBinaryContentRevision(@NotNull FilePath path, @NotNull String presentationName) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/shelf/SimpleBinaryContentRevision", "<init>"));
        }
        if (presentationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationName", "com/intellij/openapi/vcs/changes/shelf/SimpleBinaryContentRevision", "<init>"));
        }
        this.myPath = path;
        this.myRevisionPresentationName = presentationName;
    }

    @Nullable
    public String getContent() throws VcsException {
        throw new IllegalStateException();
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/SimpleBinaryContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = new VcsRevisionNumber(){

            public String asString() {
                return SimpleBinaryContentRevision.this.myRevisionPresentationName;
            }

            public int compareTo(VcsRevisionNumber o2) {
                return -1;
            }
        };
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/SimpleBinaryContentRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }
}

