/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.UnshelvePatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)ObjectUtils.assertNotNull((Object)UnshelveWithDialogAction.getEventProject((AnActionEvent)e2));
        DataContext dataContext = e2.getDataContext();
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dataContext);
        if (changeLists.isEmpty()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (changeLists.size() > 1) {
            UnshelveWithDialogAction.unshelveMultipleShelveChangeLists(project2, changeLists, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext), ShelvedChangesViewManager.getShelveChanges(dataContext));
        } else {
            ShelvedChangeList changeList = changeLists.get(0);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(changeList.PATH));
            if (virtualFile == null) {
                VcsBalloonProblemNotifier.showOverChangesView(project2, "Can not find path file", MessageType.ERROR, new NamedRunnable[0]);
                return;
            }
            List binaryShelvedPatches = ContainerUtil.map(changeList.getBinaryFiles(), ShelvedBinaryFilePatch::new);
            MyUnshelveDialog dialog2 = new MyUnshelveDialog(project2, virtualFile, changeList, binaryShelvedPatches, (Change[])e2.getData(VcsDataKeys.CHANGES));
            dialog2.setHelpId("reference.dialogs.vcs.unshelve");
            dialog2.show();
        }
    }

    private static void unshelveMultipleShelveChangeLists(final @NotNull Project project2, @NotNull List<ShelvedChangeList> changeLists, @NotNull List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "unshelveMultipleShelveChangeLists"));
        }
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "unshelveMultipleShelveChangeLists"));
        }
        if (binaryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryFiles", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "unshelveMultipleShelveChangeLists"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "unshelveMultipleShelveChangeLists"));
        }
        String suggestedName = changeLists.get((int)0).DESCRIPTION;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        ChangeListChooser chooser = new ChangeListChooser(project2, changeListManager.getChangeListsCopy(), (ChangeList)changeListManager.getDefaultChangeList(), VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0]), suggestedName){

            @Nullable
            protected JComponent createDoNotAskCheckbox() {
                return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(project2);
            }
        };
        if (!chooser.showAndGet()) {
            return;
        }
        ShelveChangesManager.getInstance(project2).unshelveSilentlyAsynchronously(project2, changeLists, changes, binaryFiles, chooser.getSelectedList());
    }

    private static boolean hasNotAllSelectedChanges(@NotNull Project project2, @NotNull ShelvedChangeList list2, @Nullable Change[] changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "hasNotAllSelectedChanges"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "hasNotAllSelectedChanges"));
        }
        return changes != null && list2.getChanges(project2).size() + list2.getBinaryFiles().size() != changes.length;
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(UnshelveWithDialogAction.getEventProject((AnActionEvent)e2) != null && !ShelvedChangesViewManager.getShelvedLists(e2.getDataContext()).isEmpty());
    }

    @NotNull
    private static JCheckBox createRemoveFilesStrategyCheckbox(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "createRemoveFilesStrategyCheckbox"));
        }
        final JCheckBox removeOptionCheckBox = new JCheckBox("Remove successfully applied files from the shelf");
        removeOptionCheckBox.setMnemonic(82);
        final ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project2);
        removeOptionCheckBox.setSelected(shelveChangesManager.isRemoveFilesFromShelf());
        removeOptionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                shelveChangesManager.setRemoveFilesFromShelf(removeOptionCheckBox.isSelected());
            }
        });
        JCheckBox jCheckBox = removeOptionCheckBox;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "createRemoveFilesStrategyCheckbox"));
        }
        return jCheckBox;
    }

    private static class MyUnshelveDialog
    extends ApplyPatchDifferentiatedDialog {
        public MyUnshelveDialog(@NotNull Project project2, @NotNull VirtualFile patchFile, @NotNull ShelvedChangeList changeList, @NotNull List<ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Change[] preselectedChanges) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            if (patchFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchFile", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            if (binaryShelvedPatches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryShelvedPatches", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog", "<init>"));
            }
            super(project2, new UnshelvePatchDefaultExecutor(project2, changeList), Collections.emptyList(), ApplyPatchMode.UNSHELVE, patchFile, null, changeList.isMarkedToDelete() ? ChangeListUtil.getPredefinedChangeList(changeList.DESCRIPTION, ChangeListManager.getInstance((Project)project2)) : null, binaryShelvedPatches, UnshelveWithDialogAction.hasNotAllSelectedChanges(project2, changeList, preselectedChanges) ? ContainerUtil.newArrayList((Object[])preselectedChanges) : null, changeList.DESCRIPTION, true);
        }

        @Nullable
        protected JComponent createDoNotAskCheckbox() {
            return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(this.myProject);
        }
    }
}

