/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowser
extends ChangesBrowserBase<Change> {
    public ChangesBrowser(@NotNull Project project2, @Nullable List<? extends ChangeList> changeLists, @NotNull List<Change> changes, @Nullable ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, @NotNull MyUseCase useCase, @Nullable VirtualFile toSelect) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "<init>"));
        }
        if (useCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useCase", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "<init>"));
        }
        super(project2, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, useCase, toSelect, Change.class);
        this.init();
        this.setInitialSelection(changeLists, changes, initialListSelection);
        this.rebuildList();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges(this.myProject, showFlatten, changes, changeNodeDecorator);
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "buildTreeModel"));
        }
        return defaultTreeModel;
    }

    @Override
    @NotNull
    protected List<Change> getSelectedObjects(@NotNull ChangesBrowserNode<Change> node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getSelectedObjects"));
        }
        List<Change> list2 = node.getAllChangesUnder();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getSelectedObjects"));
        }
        return list2;
    }

    @Override
    @Nullable
    protected Change getLeadSelectedObject(@NotNull ChangesBrowserNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getLeadSelectedObject"));
        }
        Object o2 = node.getUserObject();
        if (o2 instanceof Change) {
            return (Change)o2;
        }
        return null;
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list2 = this.myViewer.getSelectedChanges();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getSelectedChanges"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getAllChanges() {
        List<Change> list2 = this.myViewer.getChanges();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getAllChanges"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getCurrentDisplayedChanges() {
        List<Change> list2 = this.myChangesToDisplay != null ? this.myChangesToDisplay : super.getCurrentDisplayedChanges();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getCurrentDisplayedChanges"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getCurrentIncludedChanges() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myViewer.getIncludedChanges());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getCurrentIncludedChanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Change> getCurrentDisplayedObjects() {
        List<Change> list2 = this.getCurrentDisplayedChanges();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowser", "getCurrentDisplayedObjects"));
        }
        return list2;
    }

    public static enum MyUseCase {
        LOCAL_CHANGES,
        COMMITTED_CHANGES;

    }
}

