/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

class ChangesBrowserNodeCopyProvider
implements CopyProvider {
    @NotNull
    private final JTree myTree;

    ChangesBrowserNodeCopyProvider(@NotNull JTree tree2) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeCopyProvider", "<init>"));
        }
        this.myTree = tree2;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeCopyProvider", "isCopyEnabled"));
        }
        return this.myTree.getSelectionPaths() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeCopyProvider", "isCopyVisible"));
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeCopyProvider", "performCopy"));
        }
        List paths = ContainerUtil.sorted(Arrays.asList((Object[])ObjectUtils.assertNotNull((Object)this.myTree.getSelectionPaths())), (Comparator)TreeUtil.getDisplayOrderComparator((JTree)this.myTree));
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join((Collection)paths, (Function)new Function<TreePath, String>(){

            public String fun(TreePath path) {
                Object node = path.getLastPathComponent();
                if (node instanceof ChangesBrowserNode) {
                    return ((ChangesBrowserNode)node).getTextPresentation();
                }
                return node.toString();
            }
        }, (String)"\n")));
    }
}

