/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends Tree
implements TypeSafeDataProvider,
DnDAware {
    private final Project myProject;
    private boolean myShowFlatten;
    private final CopyProvider myCopyProvider;
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<Stream<VirtualFile>> UNVERSIONED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> IGNORED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "<init>"));
        }
        this.myShowFlatten = false;
        this.myProject = project2;
        this.setModel(TreeModelBuilder.buildEmpty(project2));
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setDragEnabled(true);
        this.myCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
        ChangesBrowserNodeRenderer renderer = new ChangesBrowserNodeRenderer(project2, () -> this.myShowFlatten, true);
        this.setCellRenderer((TreeCellRenderer)((Object)renderer));
        new TreeSpeedSearch(this, ChangesBrowserNode.TO_TEXT_CONVERTER);
        SmartExpander.installOn((JTree)((Object)this));
        new TreeLinkMouseListener(renderer).installOn((Component)((Object)this));
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void setShowFlatten(boolean showFlatten) {
        this.myShowFlatten = showFlatten;
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModel", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "updateModel"));
        }
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        DefaultTreeModel oldModel = this.getModel();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        this.expandPath(new TreePath(newRoot.getPath()));
        state.applyTo((JTree)((Object)this), newRoot);
        this.expandDefaultChangeList(oldModel, newRoot);
    }

    private void expandDefaultChangeList(DefaultTreeModel oldModel, ChangesBrowserNode root) {
        if (((ChangesBrowserNode)oldModel.getRoot()).getFileCount() == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() == 1) {
            TreeNode toExpand = null;
            for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
                ChangeList object;
                TreeNode node = root.getChildAt(i2);
                if (!(node instanceof ChangesBrowserChangeListNode) || node.getChildCount() <= 0 || !((object = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject()) instanceof LocalChangeList) || !((LocalChangeList)object).isDefault()) continue;
                toExpand = node;
                break;
            }
            if (toExpand != null) {
                this.expandPath(new TreePath(new Object[]{root, toExpand}));
            }
        }
    }

    public void calcData(DataKey key, DataSink sink) {
        ChangesBrowserNode firstNode;
        TreePath selectionPath;
        if (key == VcsDataKeys.CHANGES) {
            sink.put(VcsDataKeys.CHANGES, this.getSelectedChanges().toArray(Change[]::new));
        } else if (key == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, this.getLeadSelection().toArray(Change[]::new));
        } else if (key == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, this.getSelectedChangeLists().toArray(ChangeList[]::new));
        } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, this.getSelectedFiles().toArray(VirtualFile[]::new));
        } else if (key == VcsDataKeys.VIRTUAL_FILE_STREAM) {
            sink.put(VcsDataKeys.VIRTUAL_FILE_STREAM, this.getSelectedFiles());
        } else if (key == CommonDataKeys.NAVIGATABLE) {
            VirtualFile file2 = UtilKt.getIfSingle(this.getSelectedFiles());
            if (file2 != null && !file2.isDirectory()) {
                sink.put(CommonDataKeys.NAVIGATABLE, (Object)new OpenFileDescriptor(this.myProject, file2, 0));
            }
        } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getSelectedFiles()));
        } else if (key == PlatformDataKeys.DELETE_ELEMENT_PROVIDER) {
            if (this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList))) {
                sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new VirtualFileDeleteProvider());
            }
        } else if (key == PlatformDataKeys.COPY_PROVIDER) {
            sink.put(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
        } else if (key == UNVERSIONED_FILES_DATA_KEY) {
            sink.put(UNVERSIONED_FILES_DATA_KEY, this.getSelectedUnversionedFiles());
        } else if (key == IGNORED_FILES_DATA_KEY) {
            sink.put(IGNORED_FILES_DATA_KEY, this.getSelectedIgnoredFiles());
        } else if (key == VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY) {
            sink.put(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY, this.getSelectedModifiedWithoutEditing().collect(Collectors.toList()));
        } else if (key == LOCALLY_DELETED_CHANGES) {
            sink.put(LOCALLY_DELETED_CHANGES, this.getSelectedLocallyDeletedChanges().collect(Collectors.toList()));
        } else if (key == MISSING_FILES_DATA_KEY) {
            sink.put(MISSING_FILES_DATA_KEY, this.getSelectedMissingFiles().collect(Collectors.toList()));
        } else if (VcsDataKeys.HAVE_LOCALLY_DELETED == key) {
            sink.put(VcsDataKeys.HAVE_LOCALLY_DELETED, (Object)this.getSelectedMissingFiles().findAny().isPresent());
        } else if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING == key) {
            sink.put(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING, (Object)this.getSelectedModifiedWithoutEditing().findAny().isPresent());
        } else if (VcsDataKeys.HAVE_SELECTED_CHANGES == key) {
            sink.put(VcsDataKeys.HAVE_SELECTED_CHANGES, (Object)this.haveSelectedChanges());
        } else if (key == PlatformDataKeys.HELP_ID) {
            sink.put(PlatformDataKeys.HELP_ID, (Object)HELP_ID);
        } else if (key == VcsDataKeys.CHANGES_IN_LIST_KEY && (selectionPath = this.getSelectionPath()) != null && selectionPath.getPathCount() > 1 && (firstNode = (ChangesBrowserNode)selectionPath.getPathComponent(1)) instanceof ChangesBrowserChangeListNode) {
            sink.put(VcsDataKeys.CHANGES_IN_LIST_KEY, firstNode.getAllChangesUnder());
        }
    }

    @NotNull
    private Stream<VirtualFile> getSelectedUnversionedFiles() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedUnversionedFiles"));
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedIgnoredFiles() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.IGNORED_FILES_TAG);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedIgnoredFiles"));
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedModifiedWithoutEditing"));
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        Stream<VirtualFile> stream = this.getSelectionNodesStream(tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedVirtualFiles"));
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        Stream<ChangesBrowserNode<?>> stream = this.getSelectionNodesStream(null);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectionNodesStream"));
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@Nullable Object tag) {
        Stream<ChangesBrowserNode<?>> stream = UtilKt.stream(this.getSelectionPaths()).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectionNodesStream"));
        }
        return stream;
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        Stream<Object> stream = this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectionObjectsStream"));
        }
        return stream;
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(@Nullable TreePath[] paths, @Nullable Object tag) {
        Stream<VirtualFile> stream = UtilKt.stream(paths).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getVirtualFiles"));
        }
        return stream;
    }

    static boolean isUnderTag(@NotNull TreePath path, @Nullable Object tag) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "isUnderTag"));
        }
        boolean result2 = true;
        if (tag != null) {
            result2 = path.getPathCount() > 1 && ((ChangesBrowserNode)path.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project2, @Nullable TreePath[] paths) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getChanges"));
        }
        Stream<Change> changes = UtilKt.stream(paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file2 -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "lambda$getChanges$12"));
            }
            return ChangesListView.toHijackedChange(project2, file2);
        }).filter(Objects::nonNull);
        Stream<Change> stream = Stream.concat(changes, hijackedChanges).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getChanges"));
        }
        return stream;
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "toHijackedChange"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "toHijackedChange"));
        }
        VcsCurrentRevisionProxy before = VcsCurrentRevisionProxy.create(file2, project2);
        if (before != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        Stream<LocallyDeletedChange> stream = this.getSelectionNodesStream(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedLocallyDeletedChanges"));
        }
        return stream;
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        Stream<FilePath> stream = this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedMissingFiles"));
        }
        return stream;
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getAllFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedFiles"));
        }
        return stream;
    }

    private boolean haveSelectedChanges() {
        return this.getSelectionNodesStream().anyMatch(node -> node instanceof ChangesBrowserChangeNode || node instanceof ChangesBrowserChangeListNode && node.getChildCount() > 0);
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        Stream<Change> stream = this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getLeadSelection"));
        }
        return stream;
    }

    @NotNull
    public ChangesBrowserNode<?> getRoot() {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)this.getModel().getRoot();
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getRoot"));
        }
        return changesBrowserNode;
    }

    @NotNull
    public Stream<Change> getChanges() {
        Stream<Change> stream = this.getRoot().getObjectsUnderStream(Change.class);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getChanges"));
        }
        return stream;
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        Stream<Change> stream = ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedChanges"));
        }
        return stream;
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        Stream<ChangeList> stream = this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getSelectedChangeLists"));
        }
        return stream;
    }

    public void setMenuActions(ActionGroup menuGroup) {
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)menuGroup, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
        this.editSourceRegistration();
    }

    protected void editSourceRegistration() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesListView", "getComponent"));
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e2) {
        if (!(502 != e2.getID() || this.isSelectionEmpty() || e2.isShiftDown() || e2.isControlDown() || e2.isMetaDown() || e2.isPopupTrigger() || !this.isOverSelection(e2.getPoint()))) {
            this.clearSelection();
            TreePath path = this.getPathForLocation(e2.getPoint().x, e2.getPoint().y);
            if (path != null) {
                this.setSelectionPath(path);
            }
        }
        super.processMouseEvent(e2);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }
}

