/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CacheChangeProcessor;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitExecutorWithHelp;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.PseudoMap;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ui.AlienChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.AlienLocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.changes.ui.MultipleChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.impl.CheckinHandlersManager;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitChangeListDialog
extends DialogWrapper
implements CheckinProjectPanel,
TypeSafeDataProvider {
    private static final String HELP_ID = "reference.dialogs.vcs.commit";
    private static final String TITLE = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
    private static final int LAYOUT_VERSION = 2;
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION_2";
    private static final String DETAILS_SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_2";
    private static final String DETAILS_SHOW_OPTION = "CommitChangeListDialog.DETAILS_SHOW_OPTION_";
    private static final float SPLITTER_PROPORTION_OPTION_DEFAULT = 0.5f;
    private static final float DETAILS_SPLITTER_PROPORTION_OPTION_DEFAULT = 0.6f;
    private static final boolean DETAILS_SHOW_OPTION_DEFAULT = true;
    private static final Comparator<AbstractVcs> VCS_COMPARATOR = Comparator.comparing(it -> it.getKeyInstanceMethod().getName(), String::compareToIgnoreCase);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final List<CommitExecutor> myExecutors;
    private final boolean myShowVcsCommit;
    @Nullable
    private final AbstractVcs mySingleVcs;
    private final boolean myIsAlien;
    @Nullable
    private final CommitResultHandler myResultHandler;
    @NotNull
    private final List<CheckinHandler> myHandlers;
    @NotNull
    private final Map<AbstractVcs, JPanel> myPerVcsOptionsPanels;
    @NotNull
    private final List<RefreshableOnComponent> myAdditionalComponents;
    @NotNull
    private final Map<String, CheckinChangeListSpecificComponent> myCheckinChangeListSpecificComponents;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    @NotNull
    private final Map<String, String> myListComments;
    @NotNull
    private final PseudoMap<Object, Object> myAdditionalData;
    @NotNull
    private final List<CommitExecutorAction> myExecutorActions;
    @NotNull
    private final CommitContext myCommitContext;
    @NotNull
    private final ChangeInfoCalculator myChangesInfoCalculator;
    @NotNull
    private final ChangesBrowserBase<?> myBrowser;
    @NotNull
    private final MyChangeProcessor myDiffDetails;
    @NotNull
    private final CommitMessage myCommitMessageArea;
    @NotNull
    private final CommitLegendPanel myLegend;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final SplitterWithSecondHideable myDetailsSplitter;
    @NotNull
    private final JLabel myWarningLabel;
    @Nullable
    private final String myHelpId;
    @Nullable
    private final CommitAction myCommitAction;
    @NotNull
    private final Alarm myOKButtonUpdateAlarm;
    @NotNull
    private final Runnable myUpdateButtonsRunnable;
    private boolean myDisposed;
    private boolean myUpdateDisabled;
    private String myLastKnownComment;
    private String myLastSelectedListName;

    public static void commitPaths(@NotNull Project project2, @NotNull Collection<FilePath> paths, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor2, @Nullable String comment) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitPaths"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitPaths"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        HashSet<Change> changes = new HashSet<Change>();
        for (FilePath path : paths) {
            changes.addAll(manager.getChangesIn(path));
        }
        CommitChangeListDialog.commitChanges(project2, changes, initialSelection, executor2, comment);
    }

    public static boolean commitChanges(@NotNull Project project2, @NotNull Collection<Change> changes, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor2, @Nullable String comment) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (executor2 == null) {
            return CommitChangeListDialog.commitChanges(project2, changes, initialSelection, CommitChangeListDialog.collectExecutors(project2, changes), true, comment, null);
        }
        return CommitChangeListDialog.commitChanges(project2, changes, initialSelection, Collections.singletonList(executor2), false, comment, null);
    }

    public static boolean commitChanges(@NotNull Project project2, @NotNull Collection<Change> changes, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (executors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        return CommitChangeListDialog.commitChanges(project2, new ArrayList<Change>(changes), initialSelection, executors, showVcsCommit, comment, customResultHandler, true);
    }

    public static boolean commitChanges(@NotNull Project project2, @NotNull List<Change> changes, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (executors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        return CommitChangeListDialog.commitChanges(project2, changes, initialSelection, executors, showVcsCommit, null, comment, customResultHandler, cancelIfNoChanges);
    }

    public static boolean commitChanges(@NotNull Project project2, @NotNull List<Change> changes, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @Nullable AbstractVcs singleVcs, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (executors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitChanges"));
        }
        if (cancelIfNoChanges && changes.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            boolean hasUnversioned;
            boolean bl = hasUnversioned = !ChangeListManagerImpl.getInstanceImpl(project2).getUnversionedFiles().isEmpty();
            if (!showVcsCommit || !hasUnversioned) {
                Messages.showInfoMessage((Project)project2, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
                return false;
            }
        }
        for (BaseCheckinHandlerFactory factory2 : CommitChangeListDialog.getCheckInFactories(project2)) {
            BeforeCheckinDialogHandler handler2 = factory2.createSystemReadyHandler(project2);
            if (handler2 == null || handler2.beforeCommitDialogShown(project2, changes, executors, showVcsCommit)) continue;
            return false;
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        CommitChangeListDialog dialog2 = new CommitChangeListDialog(project2, changes, initialSelection, executors, showVcsCommit, manager.getDefaultChangeList(), manager.getChangeListsCopy(), singleVcs, false, comment, customResultHandler);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            dialog2.show();
        } else {
            Action okAction = dialog2.getOKAction();
            if (okAction.isEnabled()) {
                okAction.actionPerformed(null);
            } else {
                dialog2.doCancelAction();
            }
        }
        return dialog2.isOK();
    }

    @NotNull
    private static List<BaseCheckinHandlerFactory> getCheckInFactories(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getCheckInFactories"));
        }
        List list2 = CheckinHandlersManager.getInstance().getRegisteredCheckinHandlerFactories(ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getCheckInFactories"));
        }
        return list2;
    }

    @NotNull
    public static List<CommitExecutor> collectExecutors(@NotNull Project project2, @NotNull Collection<Change> changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "collectExecutors"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "collectExecutors"));
        }
        ArrayList<CommitExecutor> result2 = new ArrayList<CommitExecutor>();
        for (AbstractVcs vcs : ChangesUtil.getAffectedVcses(changes, (Project)project2)) {
            result2.addAll(vcs.getCommitExecutors());
        }
        result2.addAll(ChangeListManager.getInstance((Project)project2).getRegisteredExecutors());
        ArrayList<CommitExecutor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "collectExecutors"));
        }
        return arrayList;
    }

    public static void commitAlienChanges(@NotNull Project project2, @NotNull List<Change> changes, @NotNull AbstractVcs vcs, @NotNull String changelistName, @Nullable String comment) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitAlienChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitAlienChanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitAlienChanges"));
        }
        if (changelistName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changelistName", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "commitAlienChanges"));
        }
        AlienLocalChangeList lcl = new AlienLocalChangeList(changes, changelistName);
        new CommitChangeListDialog(project2, changes, null, Collections.emptyList(), true, AlienLocalChangeList.DEFAULT_ALIEN, Collections.singletonList(lcl), vcs, true, comment, null).show();
    }

    private CommitChangeListDialog(@NotNull Project project2, @NotNull List<Change> changes, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @NotNull LocalChangeList defaultChangeList, @NotNull List<LocalChangeList> changeLists, @Nullable AbstractVcs singleVcs, boolean isAlien, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        Object mainPanel;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "<init>"));
        }
        if (executors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "<init>"));
        }
        if (defaultChangeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultChangeList", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "<init>"));
        }
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "<init>"));
        }
        super(project2, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myHandlers = ContainerUtil.newArrayList();
        this.myPerVcsOptionsPanels = ContainerUtil.newHashMap();
        this.myAdditionalComponents = ContainerUtil.newArrayList();
        this.myCheckinChangeListSpecificComponents = ContainerUtil.newHashMap();
        this.myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myUpdateButtonsRunnable = () -> {
            this.updateButtons();
            this.updateLegend();
        };
        this.myDisposed = false;
        this.myUpdateDisabled = false;
        this.myLastKnownComment = "";
        this.myCommitContext = new CommitContext();
        this.myProject = project2;
        this.myVcsConfiguration = (VcsConfiguration)ObjectUtils.assertNotNull((Object)VcsConfiguration.getInstance((Project)this.myProject));
        this.myExecutors = executors;
        this.myShowVcsCommit = showVcsCommit;
        this.mySingleVcs = singleVcs;
        this.myResultHandler = customResultHandler;
        this.myListComments = new HashMap<String, String>();
        this.myAdditionalData = new PseudoMap();
        this.myDiffDetails = new MyChangeProcessor(this.myProject);
        if (!this.myShowVcsCommit && ContainerUtil.isEmpty(this.myExecutors)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.myAllOfDefaultChangeListChangesIncluded = ContainerUtil.newHashSet(changes).containsAll(ContainerUtil.newHashSet((Iterable)defaultChangeList.getChanges()));
        this.myCommitMessageArea = new CommitMessage(project2);
        this.myIsAlien = isAlien;
        if (isAlien) {
            this.myCommitMessageArea.setChangeLists(ContainerUtil.newArrayList(changeLists));
            this.myBrowser = new AlienChangeListBrowser(project2, changeLists, changes, (ChangeList)initialSelection, true, true, singleVcs);
        } else {
            this.myCommitMessageArea.setChangeLists(ContainerUtil.createMaybeSingletonList((Object)initialSelection));
            final MultipleChangeListBrowser browser = new MultipleChangeListBrowser(project2, changeLists, changes, (ChangeList)initialSelection, true, true, new Runnable(){

                @Override
                public void run() {
                    CommitChangeListDialog.this.updateWarning();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    for (CheckinHandler handler2 : CommitChangeListDialog.this.myHandlers) {
                        handler2.includedChangesChanged();
                    }
                }
            }, this.myShowVcsCommit);
            browser.addSelectedListChangeListener(new SelectedListChangeListener(){

                @Override
                public void selectedListChanged() {
                    CommitChangeListDialog.this.myCommitMessageArea.setChangeLists(ContainerUtil.createMaybeSingletonList((Object)browser.getSelectedChangeList()));
                    CommitChangeListDialog.this.updateOnListSelection();
                }
            });
            this.myBrowser = browser;
            this.myBrowser.setAlwayExpandList(false);
        }
        this.myBrowser.getViewer().addSelectionListener(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommitChangeListDialog.this.changeDetails();
                    }
                });
            }
        });
        this.myBrowser.setDiffBottomComponent(new DiffCommitMessageEditor(this.myProject, this.myCommitMessageArea));
        this.mySplitter = new Splitter(true);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent(this.myBrowser);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.mySplitter.setProportion(PropertiesComponent.getInstance().getFloat(SPLITTER_PROPORTION_OPTION, 0.5f));
        this.myChangesInfoCalculator = new ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        this.myBrowser.getBottomPanel().add((Component)JBUI.Panels.simplePanel().addToRight((Component)this.myLegend.getComponent()), "South");
        if (!this.myVcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            this.setComment(initialSelection, comment);
        }
        String actionName = this.getCommitActionName();
        String borderTitleName = actionName.replace("_", "").replace("&", "");
        JPanel optionsPanel = this.createOptionsPanel(project2, borderTitleName);
        this.restoreState();
        if (this.myShowVcsCommit) {
            this.setTitle(TITLE);
        } else {
            this.setTitle(CommitChangeListDialog.trimEllipsis(this.myExecutors.get(0).getActionText()));
        }
        this.myCommitAction = this.myShowVcsCommit ? new CommitAction(actionName) : null;
        this.myExecutorActions = ContainerUtil.map(this.myExecutors, x$0 -> new CommitExecutorAction((CommitExecutor)x$0));
        if (this.myCommitAction != null) {
            this.myCommitAction.setOptions(this.myExecutorActions);
            this.myHelpId = HELP_ID;
        } else {
            this.myExecutorActions.get(0).putValue("DefaultAction", Boolean.TRUE);
            this.myHelpId = CommitChangeListDialog.getHelpId(this.myExecutors);
        }
        this.myWarningLabel = new JLabel();
        this.myWarningLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.myWarningLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.updateWarning();
        if (optionsPanel != null) {
            mainPanel = new JPanel((LayoutManager)((Object)new MyOptionsLayout((JComponent)this.mySplitter, optionsPanel, JBUI.scale((int)150), JBUI.scale((int)400))));
            ((Container)mainPanel).add((Component)this.mySplitter);
            ((Container)mainPanel).add(optionsPanel);
        } else {
            mainPanel = this.mySplitter;
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.myWarningLabel, new GridBag().anchor(18).weightx(1.0));
        BorderLayoutPanel rootPane = JBUI.Panels.simplePanel((Component)mainPanel).addToBottom((Component)panel2);
        this.myDetailsSplitter = new SplitterWithSecondHideable(true, "Diff", (JComponent)rootPane, new SplitterWithSecondHideable.OnOffListener<Integer>(){

            @Override
            public void on(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.refresh();
                CommitChangeListDialog.this.mySplitter.skipNextLayouting();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayouting();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height + integer);
                CommitChangeListDialog.this.repaint();
            }

            @Override
            public void off(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.clear();
                CommitChangeListDialog.this.mySplitter.skipNextLayouting();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayouting();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height - integer);
                CommitChangeListDialog.this.repaint();
            }
        }){

            @Override
            protected RefreshablePanel createDetails() {
                BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)CommitChangeListDialog.this.myDiffDetails.getComponent());
                return new RefreshablePanel((JPanel)panel2){
                    final /* synthetic */ JPanel val$panel;
                    {
                        this.val$panel = jPanel;
                    }

                    @Override
                    public void refresh() {
                    }

                    @Override
                    public JPanel getPanel() {
                        return this.val$panel;
                    }
                };
            }

            @Override
            protected float getSplitterInitialProportion() {
                float value2 = PropertiesComponent.getInstance().getFloat(CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_OPTION, 0.6f);
                return (double)value2 <= 0.05 || (double)value2 >= 0.95 ? 0.6f : value2;
            }
        };
        this.init();
        this.updateButtons();
        this.updateVcsOptionsVisibility();
        this.updateOnListSelection();
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions(EditChangelistSupport.EP_NAME, (AreaInstance)project2)) {
            support.installSearch(this.myCommitMessageArea.getEditorField(), this.myCommitMessageArea.getEditorField());
        }
        this.showDetailsIfSaved();
    }

    @Nullable
    private JPanel createOptionsPanel(@NotNull Project project2, @NotNull String borderTitleName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "createOptionsPanel"));
        }
        if (borderTitleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderTitleName", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "createOptionsPanel"));
        }
        boolean hasVcsOptions = false;
        Box vcsCommitOptions = Box.createVerticalBox();
        for (AbstractVcs vcs : ContainerUtil.sorted(this.getAffectedVcses(), VCS_COMPARATOR)) {
            RefreshableOnComponent options;
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (checkinEnvironment == null || (options = checkinEnvironment.createAdditionalOptionsPanel((CheckinProjectPanel)this, this.myAdditionalData)) == null) continue;
            JPanel vcsOptions = new JPanel(new BorderLayout());
            vcsOptions.add((Component)options.getComponent(), "Center");
            vcsOptions.setBorder((Border)IdeBorderFactory.createTitledBorder((String)vcs.getDisplayName(), (boolean)true));
            vcsCommitOptions.add(vcsOptions);
            this.myPerVcsOptionsPanels.put(vcs, vcsOptions);
            this.myAdditionalComponents.add(options);
            if (options instanceof CheckinChangeListSpecificComponent) {
                this.myCheckinChangeListSpecificComponents.put(vcs.getName(), (CheckinChangeListSpecificComponent)options);
            }
            hasVcsOptions = true;
        }
        boolean beforeVisible = false;
        boolean afterVisible = false;
        Box beforeBox = Box.createVerticalBox();
        Box afterBox = Box.createVerticalBox();
        for (BaseCheckinHandlerFactory factory2 : CommitChangeListDialog.getCheckInFactories(project2)) {
            RefreshableOnComponent afterPanel;
            CheckinHandler handler2 = factory2.createHandler((CheckinProjectPanel)this, this.myCommitContext);
            if (CheckinHandler.DUMMY.equals(handler2)) continue;
            this.myHandlers.add(handler2);
            RefreshableOnComponent beforePanel = handler2.getBeforeCheckinConfigurationPanel();
            if (beforePanel != null) {
                beforeBox.add(beforePanel.getComponent());
                beforeVisible = true;
                this.myAdditionalComponents.add(beforePanel);
            }
            if ((afterPanel = handler2.getAfterCheckinConfigurationPanel(this.getDisposable())) == null) continue;
            afterBox.add(afterPanel.getComponent());
            afterVisible = true;
            this.myAdditionalComponents.add(afterPanel);
        }
        if (!(hasVcsOptions || beforeVisible || afterVisible)) {
            return null;
        }
        Box optionsBox = Box.createVerticalBox();
        if (hasVcsOptions) {
            vcsCommitOptions.add(Box.createVerticalGlue());
            optionsBox.add(vcsCommitOptions);
        }
        if (beforeVisible) {
            beforeBox.add(Box.createVerticalGlue());
            JPanel beforePanel = new JPanel(new BorderLayout());
            beforePanel.add(beforeBox);
            beforePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(beforePanel);
        }
        if (afterVisible) {
            afterBox.add(Box.createVerticalGlue());
            JPanel afterPanel = new JPanel(new BorderLayout());
            afterPanel.add(afterBox);
            afterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(afterPanel);
        }
        optionsBox.add(Box.createVerticalGlue());
        JPanel additionalOptionsPanel = new JPanel(new BorderLayout());
        additionalOptionsPanel.add((Component)optionsBox, "North");
        JScrollPane optionsPane = ScrollPaneFactory.createScrollPane((Component)additionalOptionsPanel, (boolean)true);
        return JBUI.Panels.simplePanel((Component)optionsPane).withBorder((Border)JBUI.Borders.emptyLeft((int)10));
    }

    @Nullable
    private static String getHelpId(@NotNull List<CommitExecutor> executors) {
        if (executors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getHelpId"));
        }
        for (CommitExecutor executor2 : executors) {
            String helpId;
            if (!(executor2 instanceof CommitExecutorWithHelp) || (helpId = ((CommitExecutorWithHelp)executor2).getHelpId()) == null) continue;
            return helpId;
        }
        return null;
    }

    private void setComment(@Nullable LocalChangeList initialSelection, @Nullable String comment) {
        if (comment != null) {
            this.setCommitMessage(comment);
            this.myLastKnownComment = comment;
            this.myLastSelectedListName = initialSelection == null ? this.myBrowser.getSelectedChangeList().getName() : initialSelection.getName();
        } else {
            this.updateComment();
            if (StringUtil.isEmptyOrSpaces((String)this.myCommitMessageArea.getComment())) {
                this.setCommitMessage(this.myVcsConfiguration.LAST_COMMIT_MESSAGE);
                String messageFromVcs = this.getInitialMessageFromVcs();
                if (messageFromVcs != null) {
                    this.myCommitMessageArea.setText(messageFromVcs);
                }
            }
        }
    }

    private void showDetailsIfSaved() {
        boolean showDetails = PropertiesComponent.getInstance().getBoolean(DETAILS_SHOW_OPTION, true);
        if (showDetails) {
            this.myDetailsSplitter.initOn();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommitChangeListDialog.this.changeDetails();
            }
        });
    }

    private void updateOnListSelection() {
        this.updateComment();
        this.updateVcsOptionsVisibility();
        for (CheckinChangeListSpecificComponent component : this.myCheckinChangeListSpecificComponents.values()) {
            component.onChangeListSelected((LocalChangeList)this.myBrowser.getSelectedChangeList());
        }
    }

    private void updateWarning() {
        if (this.myWarningLabel != null) {
            String[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)this.myProject)).getUpdateException();
            if (updateException != null && (messages = updateException.getMessages()) != null && messages.length > 0) {
                String message2 = messages[0];
                this.myWarningLabel.setText("Warning: not all local changes may be shown due to an error: " + message2);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    private void updateVcsOptionsVisibility() {
        Set affectedVcses = ChangesUtil.getAffectedVcses((Collection)this.myBrowser.getSelectedChangeList().getChanges(), (Project)this.myProject);
        for (Map.Entry<AbstractVcs, JPanel> entry : this.myPerVcsOptionsPanels.entrySet()) {
            entry.getValue().setVisible(affectedVcses.contains(entry.getKey()));
        }
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    private boolean addUnversionedFiles() {
        return ScheduleForAdditionAction.addUnversioned(this.myProject, this.myBrowser.getIncludedUnversionedFiles(), ChangeListManagerImpl.getDefaultUnversionedFileCondition(), this.myBrowser);
    }

    @NotNull
    protected Action getOKAction() {
        Action action2 = this.myCommitAction != null ? this.myCommitAction : (Action)this.myExecutorActions.get(0);
        if (action2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getOKAction"));
        }
        return action2;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions2 = new ArrayList<Action>();
        if (this.myCommitAction != null) {
            actions2.add(this.myCommitAction);
        } else {
            actions2.addAll(this.myExecutorActions);
        }
        actions2.add(this.getCancelAction());
        if (this.myHelpId != null) {
            actions2.add(this.getHelpAction());
        }
        Action[] actionArray = actions2.toArray(new Action[actions2.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "createActions"));
        }
        return actionArray;
    }

    private void executeDefaultCommitSession() {
        if (!this.myIsAlien && !this.addUnversionedFiles()) {
            return;
        }
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        this.ensureDataIsActual(() -> {
            try {
                DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
                CheckinHandler.ReturnResult result2 = this.runBeforeCommitHandlers(null);
                if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                    this.close(0);
                    this.doCommit(this.myResultHandler);
                    defaultListCleaner.clean();
                }
            }
            catch (InputException ex) {
                ex.show();
            }
        });
    }

    private void execute(CommitExecutor commitExecutor) {
        CommitSession session2 = commitExecutor.createCommitSession();
        if (session2 == CommitSession.VCS_COMMIT) {
            this.executeDefaultCommitSession();
            return;
        }
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        if (session2 instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)session2).setContext(this.myCommitContext);
        }
        this.ensureDataIsActual(() -> {
            SessionDialog sessionDialog;
            JComponent configurationUI = SessionDialog.createConfigurationUI(session2, this.getIncludedChanges(), this.getCommitMessage());
            if (configurationUI != null && !(sessionDialog = new SessionDialog(commitExecutor.getActionText(), this.getProject(), session2, this.getIncludedChanges(), this.getCommitMessage(), configurationUI)).showAndGet()) {
                session2.executionCanceled();
                return;
            }
            DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
            CheckinHandler.ReturnResult result2 = this.runBeforeCommitHandlers(commitExecutor);
            if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                boolean success = false;
                try {
                    boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> session2.execute(this.getIncludedChanges(), this.getCommitMessage()), commitExecutor.getActionText(), true, this.getProject());
                    if (completed) {
                        for (CheckinHandler handler2 : this.myHandlers) {
                            handler2.checkinSuccessful();
                        }
                        success = true;
                        defaultListCleaner.clean();
                        this.close(0);
                    } else {
                        session2.executionCanceled();
                    }
                }
                catch (Throwable e2) {
                    Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])new Object[]{commitExecutor.getActionText(), e2.getLocalizedMessage()}), (String)commitExecutor.getActionText());
                    for (CheckinHandler handler3 : this.myHandlers) {
                        handler3.checkinFailed(Collections.singletonList(new VcsException(e2)));
                    }
                }
                finally {
                    if (this.myResultHandler != null) {
                        if (success) {
                            this.myResultHandler.onSuccess(this.getCommitMessage());
                        } else {
                            this.myResultHandler.onFailure();
                        }
                    }
                }
            }
        });
    }

    @Nullable
    private String getInitialMessageFromVcs() {
        List<Change> list2 = this.getIncludedChanges();
        Ref result2 = new Ref();
        ChangesUtil.processChangesByVcs((Project)this.myProject, list2, (vcs, items2) -> {
            List paths;
            String defaultMessage;
            CheckinEnvironment checkinEnvironment;
            if (result2.isNull() && (checkinEnvironment = vcs.getCheckinEnvironment()) != null && (defaultMessage = checkinEnvironment.getDefaultMessageFor((paths = ChangesUtil.getPaths((Collection)items2)).toArray(new FilePath[paths.size()]))) != null) {
                result2.set((Object)defaultMessage);
            }
        });
        return (String)result2.get();
    }

    private void saveCommentIntoChangeList() {
        if (this.myLastSelectedListName != null) {
            String actualCommentText = this.myCommitMessageArea.getComment();
            String saved = this.myListComments.get(this.myLastSelectedListName);
            if (!Comparing.equal((String)saved, (String)actualCommentText)) {
                this.myListComments.put(this.myLastSelectedListName, actualCommentText);
            }
        }
    }

    private void updateComment() {
        if (this.myVcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        LocalChangeList list2 = (LocalChangeList)this.myBrowser.getSelectedChangeList();
        if (list2 == null || list2.getName().equals(this.myLastSelectedListName)) {
            return;
        }
        if (this.myLastSelectedListName != null) {
            this.saveCommentIntoChangeList();
        }
        this.myLastSelectedListName = list2.getName();
        String listComment = list2.getComment();
        if (StringUtil.isEmptyOrSpaces((String)listComment)) {
            String listTitle = list2.getName();
            listComment = !list2.hasDefaultName() ? listTitle : this.myLastKnownComment;
        }
        this.myCommitMessageArea.setText(listComment);
    }

    public void dispose() {
        this.myDisposed = true;
        Disposer.dispose(this.myBrowser);
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.myOKButtonUpdateAlarm);
        super.dispose();
        Disposer.dispose((Disposable)this.myDiffDetails);
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, this.mySplitter.getProportion(), 0.5f);
        float usedProportion = this.myDetailsSplitter.getUsedProportion();
        if (usedProportion > 0.0f) {
            PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION_OPTION, usedProportion, 0.6f);
        }
        PropertiesComponent.getInstance().setValue(DETAILS_SHOW_OPTION, this.myDetailsSplitter.isOn(), true);
    }

    public String getCommitActionName() {
        String name = null;
        for (AbstractVcs vcs : this.getAffectedVcses()) {
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (name == null && checkinEnvironment != null) {
                name = checkinEnvironment.getCheckinOperationName();
                continue;
            }
            name = VcsBundle.getString((String)"commit.dialog.default.commit.operation.name");
        }
        return name != null ? name : VcsBundle.getString((String)"commit.dialog.default.commit.operation.name");
    }

    private boolean checkComment() {
        if (this.myVcsConfiguration.FORCE_NON_EMPTY_COMMENT && this.getCommitMessage().isEmpty()) {
            int requestForCheckin = Messages.showYesNoDialog((String)VcsBundle.message((String)"confirmation.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"confirmation.title.check.in.with.empty.comment", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return requestForCheckin == 0;
        }
        return true;
    }

    private void stopUpdate() {
        this.myUpdateDisabled = true;
    }

    private void restartUpdate() {
        this.myUpdateDisabled = false;
        this.myUpdateButtonsRunnable.run();
    }

    private CheckinHandler.ReturnResult runBeforeCommitHandlers(final @Nullable CommitExecutor executor2) {
        Computable<CheckinHandler.ReturnResult> proceedRunnable = new Computable<CheckinHandler.ReturnResult>(){

            public CheckinHandler.ReturnResult compute() {
                FileDocumentManager.getInstance().saveAllDocuments();
                for (CheckinHandler handler2 : CommitChangeListDialog.this.myHandlers) {
                    CheckinHandler.ReturnResult result2;
                    if (!handler2.acceptExecutor(executor2) || (result2 = handler2.beforeCheckin(executor2, (PairConsumer)CommitChangeListDialog.this.myAdditionalData)) == CheckinHandler.ReturnResult.COMMIT) continue;
                    if (result2 == CheckinHandler.ReturnResult.CANCEL) {
                        CommitChangeListDialog.this.restartUpdate();
                        return CheckinHandler.ReturnResult.CANCEL;
                    }
                    if (result2 != CheckinHandler.ReturnResult.CLOSE_WINDOW) continue;
                    ChangeList changeList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
                    CommitHelper.moveToFailedList(changeList, CommitChangeListDialog.this.getCommitMessage(), CommitChangeListDialog.this.getIncludedChanges(), VcsBundle.message((String)"commit.dialog.rejected.commit.template", (Object[])new Object[]{changeList.getName()}), CommitChangeListDialog.this.myProject);
                    CommitChangeListDialog.this.doCancelAction();
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
        };
        this.stopUpdate();
        final Ref compoundResultRef = Ref.create();
        Runnable runnable2 = new Runnable((Computable)proceedRunnable){
            final /* synthetic */ Computable val$proceedRunnable;
            {
                this.val$proceedRunnable = computable;
            }

            @Override
            public void run() {
                compoundResultRef.set(this.val$proceedRunnable.compute());
            }
        };
        for (final CheckinHandler handler2 : this.myHandlers) {
            if (!(handler2 instanceof CheckinMetaHandler)) continue;
            final Runnable previousRunnable = runnable2;
            runnable2 = new Runnable(){

                @Override
                public void run() {
                    ((CheckinMetaHandler)handler2).runCheckinHandlers(previousRunnable);
                }
            };
        }
        runnable2.run();
        return (CheckinHandler.ReturnResult)compoundResultRef.get();
    }

    private boolean saveDialogState() {
        if (!this.checkComment()) {
            return false;
        }
        this.saveCommentIntoChangeList();
        this.myVcsConfiguration.saveCommitMessage(this.getCommitMessage());
        try {
            this.saveState();
        }
        catch (InputException ex) {
            ex.show();
            return false;
        }
        return true;
    }

    private void saveComments(boolean isOk) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        if (isOk) {
            int selectedSize = this.getIncludedChanges().size();
            ChangeList selectedList = this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            if (totalSize > selectedSize) {
                this.myListComments.remove(this.myLastSelectedListName);
            }
        }
        for (Map.Entry<String, String> entry : this.myListComments.entrySet()) {
            String name = entry.getKey();
            String value2 = entry.getValue();
            clManager.editComment(name, value2);
        }
    }

    public void doCancelAction() {
        for (CheckinChangeListSpecificComponent component : this.myCheckinChangeListSpecificComponents.values()) {
            component.saveState();
        }
        this.saveCommentIntoChangeList();
        this.saveComments(false);
        super.doCancelAction();
    }

    private void doCommit(@Nullable CommitResultHandler customResultHandler) {
        CommitHelper helper = new CommitHelper(this.myProject, this.myBrowser.getSelectedChangeList(), this.getIncludedChanges(), TITLE, this.getCommitMessage(), this.myHandlers, this.myAllOfDefaultChangeListChangesIncluded, false, (NullableFunction<Object, Object>)this.myAdditionalData, customResultHandler);
        if (this.myIsAlien) {
            helper.doAlienCommit(this.mySingleVcs);
        } else {
            helper.doCommit(this.mySingleVcs);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myDetailsSplitter.getComponent();
    }

    @NotNull
    public Set<AbstractVcs> getAffectedVcses() {
        Set<AbstractVcs> set2 = this.myShowVcsCommit ? this.myBrowser.getAffectedVcses() : Collections.emptySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getAffectedVcses"));
        }
        return set2;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        Set set2 = ContainerUtil.map2SetNotNull(this.myBrowser.getCurrentDisplayedChanges(), change -> vcsManager.getVcsRootFor(ChangesUtil.getFilePath((Change)change)));
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getRoots"));
        }
        return set2;
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty() || !this.myBrowser.getIncludedUnversionedFiles().isEmpty();
    }

    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        List list2 = ContainerUtil.mapNotNull(this.getIncludedChanges(), change -> ChangesUtil.getFilePath((Change)change).getVirtualFile());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getVirtualFiles"));
        }
        return list2;
    }

    @NotNull
    public Collection<Change> getSelectedChanges() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.getIncludedChanges());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getSelectedChanges"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getFiles() {
        List list2 = ContainerUtil.map(this.getIncludedChanges(), change -> ChangesUtil.getFilePath((Change)change).getIOFile());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getFiles"));
        }
        return list2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getProject"));
        }
        return project2;
    }

    public boolean vcsIsAffected(String name) {
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).checkVcsIsActive(name)) {
            return false;
        }
        return ContainerUtil.exists(this.myBrowser.getAffectedVcses(), vcs -> Comparing.equal((String)vcs.getName(), (String)name));
    }

    public void setCommitMessage(String currentDescription) {
        this.setCommitMessageText(currentDescription);
        this.myCommitMessageArea.requestFocusInMessage();
    }

    private void setCommitMessageText(String currentDescription) {
        this.myLastKnownComment = currentDescription;
        this.myCommitMessageArea.setText(currentDescription);
    }

    @NotNull
    public String getCommitMessage() {
        String string2 = this.myCommitMessageArea.getComment();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getCommitMessage"));
        }
        return string2;
    }

    public void refresh() {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                CommitChangeListDialog.this.myBrowser.rebuildList();
                for (RefreshableOnComponent component : CommitChangeListDialog.this.myAdditionalComponents) {
                    component.refresh();
                }
            }
        }, InvokeAfterUpdateMode.SILENT, "commit dialog", ModalityState.current());
    }

    public void saveState() {
        for (RefreshableOnComponent component : this.myAdditionalComponents) {
            component.saveState();
        }
    }

    public void restoreState() {
        for (RefreshableOnComponent component : this.myAdditionalComponents) {
            component.restoreState();
        }
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        List<RefreshableOnComponent> list2 = Collections.unmodifiableList(this.myAdditionalComponents);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getAdditionalComponents"));
        }
        return list2;
    }

    private void updateButtons() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        boolean enabled = this.hasDiffs();
        if (this.myCommitAction != null) {
            this.myCommitAction.setEnabled(enabled);
        }
        for (CommitExecutorAction executorAction : this.myExecutorActions) {
            executorAction.updateEnabled(enabled);
        }
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest(this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent(this.myBrowser));
    }

    private void updateLegend() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        this.myChangesInfoCalculator.update(this.myBrowser.getCurrentDisplayedChanges(), this.getIncludedChanges(), this.myBrowser.getUnversionedFilesCount(), this.myBrowser.getIncludedUnversionedFiles().size());
        this.myLegend.update();
    }

    @NotNull
    private List<Change> getIncludedChanges() {
        List<Change> list2 = this.myBrowser.getCurrentIncludedChanges();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getIncludedChanges"));
        }
        return list2;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "CommitChangelistDialog2";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getEditorField();
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key == Refreshable.PANEL_KEY) {
            sink.put(Refreshable.PANEL_KEY, (Object)this);
        } else {
            this.myBrowser.calcData(key, sink);
        }
    }

    static String trimEllipsis(String title) {
        return StringUtil.trimEnd((String)title, (String)"...");
    }

    private void ensureDataIsActual(Runnable runnable2) {
        if (this.myBrowser.isDataIsDirty()) {
            ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(runnable2, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing changelists...", ModalityState.current());
        } else {
            runnable2.run();
        }
    }

    private void changeDetails() {
        if (this.myDetailsSplitter.isOn()) {
            this.myDiffDetails.refresh();
        }
    }

    private static class MyOptionsLayout
    extends AbstractLayoutManager {
        private final JComponent myPanel;
        private final JComponent myOptions;
        private final int myMinOptionsWidth;
        private final int myMaxOptionsWidth;

        public MyOptionsLayout(@NotNull JComponent panel2, @NotNull JComponent options, int minOptionsWidth, int maxOptionsWidth) {
            if (panel2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyOptionsLayout", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyOptionsLayout", "<init>"));
            }
            this.myPanel = panel2;
            this.myOptions = options;
            this.myMinOptionsWidth = minOptionsWidth;
            this.myMaxOptionsWidth = maxOptionsWidth;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size1 = this.myPanel.getPreferredSize();
            Dimension size2 = this.myOptions.getPreferredSize();
            return new Dimension(size1.width + size2.width, Math.max(size1.height, size2.height));
        }

        public void layoutContainer(Container parent) {
            Rectangle bounds = parent.getBounds();
            int preferredWidth = this.myOptions.getPreferredSize().width;
            int optionsWidth = Math.max(Math.min(this.myMaxOptionsWidth, preferredWidth), this.myMinOptionsWidth);
            this.myPanel.setBounds(new Rectangle(0, 0, bounds.width - optionsWidth, bounds.height));
            this.myOptions.setBounds(new Rectangle(bounds.width - optionsWidth, 0, optionsWidth, bounds.height));
        }
    }

    private class MyChangeProcessor
    extends CacheChangeProcessor {
        public MyChangeProcessor(Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "<init>"));
            }
            super(project2, "CommitDialog");
            this.putContextUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK, true);
        }

        @Override
        @NotNull
        protected List<Change> getSelectedChanges() {
            List<Change> list2 = CommitChangeListDialog.this.myBrowser.getSelectedChanges();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "getSelectedChanges"));
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<Change> getAllChanges() {
            List<Change> list2 = CommitChangeListDialog.this.myBrowser.getAllChanges();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "getAllChanges"));
            }
            return list2;
        }

        @Override
        protected void selectChange(@NotNull Change change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "selectChange"));
            }
            CommitChangeListDialog.this.myBrowser.select(Collections.singletonList(change));
        }

        @Override
        protected void onAfterNavigate() {
            CommitChangeListDialog.this.doCancelAction();
        }
    }

    private static class DiffCommitMessageEditor
    extends CommitMessage
    implements Disposable {
        public DiffCommitMessageEditor(@NotNull Project project2, @NotNull CommitMessage commitMessage) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$DiffCommitMessageEditor", "<init>"));
            }
            if (commitMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$DiffCommitMessageEditor", "<init>"));
            }
            super(project2, commitMessage);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 120);
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        @NotNull
        private final CommitExecutor myCommitExecutor;

        public CommitExecutorAction(CommitExecutor commitExecutor) {
            if (commitExecutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitExecutor", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitExecutorAction", "<init>"));
            }
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CommitChangeListDialog.this.execute(this.myCommitExecutor);
        }

        public void updateEnabled(boolean hasDiffs) {
            this.setEnabled(hasDiffs || this.myCommitExecutor instanceof CommitExecutorBase && !((CommitExecutorBase)this.myCommitExecutor).areChangesRequired());
        }
    }

    private class DefaultListCleaner {
        private final boolean myToClean;

        private DefaultListCleaner() {
            int selectedSize = CommitChangeListDialog.this.getIncludedChanges().size();
            ChangeList selectedList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            this.myToClean = totalSize == selectedSize && ((LocalChangeList)selectedList).hasDefaultName();
        }

        void clean() {
            if (this.myToClean) {
                ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitChangeListDialog.this.myProject);
                clManager.editComment(LocalChangeList.DEFAULT_NAME, "");
            }
        }
    }

    private class CommitAction
    extends AbstractAction
    implements OptionAction {
        private Action[] myOptions;

        private CommitAction(String okActionText) {
            super(okActionText);
            this.myOptions = new Action[0];
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CommitChangeListDialog.this.executeDefaultCommitSession();
        }

        @NotNull
        public Action[] getOptions() {
            if (this.myOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitAction", "getOptions"));
            }
            return this.myOptions;
        }

        public void setOptions(List<? extends Action> actions2) {
            this.myOptions = (Action[])ArrayUtil.toObjectArray(actions2, Action.class);
        }
    }
}

