/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathChangesTreeList
extends ChangesTreeList<FilePath> {
    public FilePathChangesTreeList(@NotNull Project project2, @NotNull List<FilePath> originalFiles, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator nodeDecorator) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/FilePathChangesTreeList", "<init>"));
        }
        if (originalFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFiles", "com/intellij/openapi/vcs/changes/ui/FilePathChangesTreeList", "<init>"));
        }
        super(project2, originalFiles, showCheckboxes, highlightProblems, inclusionListener, nodeDecorator);
    }

    @Override
    protected DefaultTreeModel buildTreeModel(List<FilePath> changes, ChangeNodeDecorator changeNodeDecorator) {
        return TreeModelBuilder.buildFromFilePaths(this.myProject, this.isShowFlatten(), changes);
    }

    @Override
    protected List<FilePath> getSelectedObjects(ChangesBrowserNode<FilePath> node) {
        return node.getAllFilePathsUnder();
    }

    @Override
    @Nullable
    protected FilePath getLeadSelectedObject(ChangesBrowserNode node) {
        Object userObject = node.getUserObject();
        return userObject instanceof FilePath ? (FilePath)userObject : null;
    }
}

